/**
　 * <p>Title: AbstractDBColumn.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年3月31日
　 * @version 1.0
*/
package com.northpool.resources.datatable.db.operate.column;

import com.northpool.resources.datatable.operate.AbstractColumn;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean.VALUE_TYPE;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;

/**
 * @author matt
 *
 */
public abstract class AbstractDBColumn extends  AbstractColumn {

    /**
     * @param columnName
     * @param columnSize
     * @param digits
     * @param columnTypeName
     * @param nullable
     * @param defaultValue
     * @param remarks
     * @param dialect
     */
    public AbstractDBColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName,
        Boolean nullable, String defaultValue, String remarks, IDialect dialect) {
        super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks, dialect);
        // TODO Auto-generated constructor stub
    }
    
    
    protected FieldDefaultValueBean getFieldDefaultValueByDefaultValue() {
        // TODO Auto-generated method stub
        
        FieldDefaultValueBean fieldDefaultValue = new FieldDefaultValueBean();
        VALUE_TYPE type = VALUE_TYPE.value;
        ISQLDialect dialect = (ISQLDialect)this.dialect;
        if(dialect.isFieldSerial(this.columnTypeName)){
            type = VALUE_TYPE.serial;
        }
        VALUE_TYPE typeByDialect = dialect.getColumnDefaultValueType(this.columnTypeName,this.defaultValue);
        if(typeByDialect != null){
            type = typeByDialect;
        }
        if(type == VALUE_TYPE.function){
            //暂时不支持
        }
        fieldDefaultValue.setType(type);
        fieldDefaultValue.setValueStr(this.defaultValue);
        
        
        return fieldDefaultValue ;
    }
 

}
