package com.northpool.resources.datatable.db.operate.column;

import com.northpool.commons.util.Functions;
import com.northpool.resources.datatable.db.operate.OracleTableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeInteger;

public class OracleColumn extends AbstractDBColumn implements IColumn {

	protected OracleTableOperator oracleTableBuilder;

	public OracleColumn(String columnName, int columnSize, int digits, String columnTypeName,
			boolean nullable, String defaultValue, String remarks, ISQLDialect sqlDialect) {
		super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks, sqlDialect);
	}

	@Override
	protected void initAttType() {
		if (Functions.hasMask(this.columnTypeName, "NUMBER") || Functions.hasMask(this.columnTypeName, "NUMERIC")) {
			if (this.columnSize <= 10) {
				this.type = TypeInteger.INSTANCE;
			} else {
				this.type = TypeBigDecimal.INSTANCE;
			}
		} else {
			this.type = this.dialect.getTypeByName(this.columnTypeName);
		}
		if (Functions.hasMask(this.columnTypeName, "GEOMETRY")) {
			this.isSpatial = true;
		}
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.IColumn#getSpatialType()
     */
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.sdo;
    }

   

}
