/**
　 * <p>Title: AbstractResourcesDataOutput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月23日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;

import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.spatial.Geom;

/**
 * @author matt
 *
 */
public abstract class AbstractResourcesDataOutput implements IResourcesDataOutput<ResultSet,Integer>{

    

   
    @Override
    public Boolean columnBoolean(ResultSet output, Integer indexOrLabelName) throws Exception {
        
        return output.getBoolean(indexOrLabelName);
    }

    
    @Override
    public BigDecimal columnBigDecimal(ResultSet output, Integer indexOrLabelName) throws Exception {
        return output.getBigDecimal(indexOrLabelName);
    }

    
    @Override
    public byte[] columnBytes(ResultSet output, Integer indexOrLabelName) throws Exception{
        return output.getBytes(indexOrLabelName);
    }

  
    @Override
    public Double columnDouble(ResultSet output, Integer indexOrLabelName) throws Exception{
        return output.getDouble(indexOrLabelName);
    }

    
    
    abstract public Geom columnGeometry(ResultSet output, Integer indexOrLabelName) throws Exception;

   
    public Integer columnInteger(ResultSet output, Integer indexOrLabelName) throws Exception{
       
        return output.getInt(indexOrLabelName);
    }

   
    @Override
    public Long columnLong(ResultSet output, Integer indexOrLabelName) throws Exception{
        return output.getLong(indexOrLabelName);
    }

   
    @Override
    public String columnString(ResultSet output, Integer indexOrLabelName) throws Exception{
        // TODO Auto-generated method stub
        return output.getString(indexOrLabelName);
    }

    
    @Override
    public Date columnTimestamp(ResultSet output, Integer indexOrLabelName) throws Exception{
        Timestamp ts = output.getTimestamp(indexOrLabelName);
        if(ts == null){
            return null;
        }else{
            return new Date(ts.getTime());
        }
    }


   
 

}
