/**
　 * <p>Title: PostgresSQLResourcesDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.oracle;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.resources.dialect.db.AbstractResourcesDataInput;
import com.northpool.spatial.Geom;
import com.northpool.spatial.oracle.GeometryOracleConverter;
import com.northpool.spatial.oracle.OracleConnectionFinder;
import com.northpool.type.TypePostGisGeometry;
import oracle.jdbc.driver.OracleConnection;

import java.sql.PreparedStatement;
import java.sql.Types;

/**
 * @author matt
 *
 */
public class OracleResourcesDataInput extends AbstractResourcesDataInput implements IResourcesDataInput<PreparedStatement,Integer>{

    static final String POSTGIS_GEOMETRY_NAME = "geometry";
    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.postgreSQL;
    }

   
    @Override
    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName,  Types.JAVA_OBJECT);
            return;
        }
        if(value instanceof Geom){
            Geom geom = (Geom) value;
            OracleConnection con = OracleConnectionFinder.getInstance().find(input.getConnection());
            GeometryOracleConverter gc = new GeometryOracleConverter(con);
            Object sdo = gc.toSDO(geom.toJTSGeometry());
            input.setObject(indexOrLabelName, sdo);
         }else{
             throw new ResourcesDataInputException(this.getDataSourceType(),TypePostGisGeometry.INSTANCE,value,"值类型不符");
         }
    }

}
