/**
　 * <p>Title: PostgresSQLResourcesDataOutput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.postgresql;

import java.sql.ResultSet;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.db.AbstractResourcesDataOutput;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Geom;

/**
 * @author matt
 *
 */
public class PostgresSQLResourcesDataOutput extends AbstractResourcesDataOutput implements  IResourcesDataOutput<ResultSet,Integer> {

    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.postgreSQL;
    }

  
    @Override
    public Geom columnGeometry(ResultSet output, Integer indexOrLabelName) throws Exception {
        String hex = output.getString(indexOrLabelName);
        if(hex == null){
            return null;
        }
        Geom m = new Geom(SPATIAL_TYPE.hexwkb,hex);
        return m;
    }

   

}
