package com.northpool.resources.sql.jdbc;

import java.io.IOException;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;

public abstract class AbstractsJDBCTransformer<T> {
	
	protected LinkedHashMap<String, Type> createTypeMap(final ResultSet rs,Map<String, Type> typeMap,final IDialect dialect) throws DataAccessException{
		ResultSetMetaData rsmd;
        try {
            rsmd = rs.getMetaData();
        
    		int columnCount = rsmd.getColumnCount();
    		if(typeMap == null){
    			typeMap = new HashMap<String, Type>();
    		}
    		LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>();
    		for (int i = 1; i <= columnCount; i++) {
    			String typeName = rsmd.getColumnTypeName(i);
    			String name = rsmd.getColumnLabel(i);
    			Type type = typeMap.get(typeName);
    			if(type == null){
    				type = dialect.getTypeByName(typeName);
    				
    			}
    			newTypeMap.put(name, type);
    		}	
    		return newTypeMap;
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            UException.printStackTrace(e);
            throw new DataAccessException(e);
        }
	}
	 
	
	abstract protected ResultSetMapping<T,ResultSet> getMapping();
	
	public List<T> extractData(final ISQLDialect dialect,final ResultSet rs, Map<String,Type> typeMap) throws DataAccessException {
	    
	    try {
    		List<T> iList = new ArrayList<T>();
    		ResultSetMapping<T,ResultSet> mapping = this.getMapping();
    		LinkedHashMap<String, Type> newTypeMap = this.createTypeMap(rs, typeMap,dialect);
    		
    		while(rs.next()){
    			T t = mapping.mapping(rs,newTypeMap,dialect);
    			iList.add(t);
    		}
    		return iList;
	    } catch (SQLException e) {
            // TODO Auto-generated catch block
            UException.printStackTrace(e);
            throw new DataAccessException(e);
        }
	}
	
	
	
    public IScroll<T> extractDataScroll(final ISQLDialect dialect, final ResultSet rs, Map<String, Type> typeMap, final JDBCScrollStatement scrollStatement) throws DataAccessException  {
        
        ResultSetMapping<T,ResultSet> mapping = this.getMapping();
        final LinkedHashMap<String, Type> newTypeMap = this.createTypeMap(rs, typeMap,dialect);
       
        IScroll<T> scroll = new IScroll<T>(){
            @Override
            public boolean hasNext()  {
                try {
                    return rs.next();
                } catch (SQLException e) {
                    // TODO Auto-generated catch block
                    UException.printStackTrace(e);
                    throw new DataAccessException(e);
                }
            }
   
            @Override
            public T next()  {
                T t = mapping.mapping(rs,newTypeMap,dialect);
                return t;
            }
   
            @Override
            public void close() throws IOException {
                AbstractsJDBCCell.closeStatement(scrollStatement.getPs());
                AbstractsJDBCCell.releaseConnection(scrollStatement.getCon(), scrollStatement.getDbDataSource());
            } 
        };
        
        return scroll;
    }
    
    
	
	
}
