package com.northpool.resources.sql.jdbc;


import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.type.Type;

import java.util.List;
import java.util.Map;

public interface IJDBCGenericDao {
	
   
    
    public Object[] excuteProcedure(final String procedureName, final ProcedureParamCell... params);
   
    
    public <T> List <T> queryBySql (final String sql, final Object[] objs,final Type[] types,final Map<String,Type> returnTypes,
        final Integer firstResult, final Integer maxResults, final Integer fetchSize,final IJDBCTransformer<T> transformer) throws DataAccessException;
    
    public List <Map<String,Object>> queryBySql(final String sql,final Object[] objs) throws DataAccessException;
        
    public <T> IScroll <T> scrollBySql(final String sql, final Object[] objs,final Type[] types,final Map<String,Type> returnTypes, 
        final Integer firstResult,final Integer maxResults, final Integer fetchSize,final  IJDBCTransformer<T> transformer);
    
    public Long getCountBySql(final String querySql,final  Object[] objs, final Type[] types);
        
    public <PK> List<PK> doBatchExecuteSql(final String sql,final List<Object[]> datas,final Type[] types,final Integer batchSize) throws DataAccessException;
    
    public <PK> List<PK> doExecuteSql(final String sql, final Object[] datas, final Type[] types) throws DataAccessException;

    public <PK> List<PK> doExecuteSql(final String sql);
    
    
}
