package com.northpool.resources.sql.jdbc;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.resources.sql.IQuery;
import com.northpool.type.Type;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JDBCGenericDaoImpl implements IJDBCGenericDao {

    protected IDataSource dataSource;

    protected ISQLDialect dialect;

    // protected DataSource dataSource;

    public JDBCGenericDaoImpl(IDataSource dataSource) {
        this.dataSource = dataSource;
        this.dialect = (ISQLDialect)IDialect.getByType(dataSource.getDataSourceType());

    }
    
    protected <T> IQuery<T,IJDBCTransformer<?>> createSQLQuery(final String sql, final Object[] args, final Type[] types,
        final Integer firstResult, final Integer maxResults, final Map<String, Type> returnType,
        final IJDBCTransformer<T> transformer) throws DataAccessException {

        IQuery<T,IJDBCTransformer<?>> query = this.SQLQuery(sql);
        query.setResultTransformer(transformer);

        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes;
            if (types == null) {
                inTypes = this.guessType(args);
            } else {
                inTypes = types;
            }
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }

        query.setFirstResult(firstResult).setMaxResults(maxResults);

        return query;
    }

    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            Type t = this.dialect.getTypeByObject(arg);
            types[i] = t;
        }
        return types;

    }

    private IDML createSQLUpdate(final String sql, final Type[] types, final Integer batchSize) {
        IDML update = this.SQLUpdate(sql);
        update.setInputTypes(types);
        if (batchSize != null) {
            update.setBatchSize(batchSize);
        }
        return update;
    }

    public <T> List <T> queryBySql(final String sql, final Object[] objs, final Type[] types,
        final Map<String, Type> returnTypes, final Integer firstResult, final Integer maxResults,
        final Integer fetchSize, final IJDBCTransformer<T> transformer) throws DataAccessException {
        IQuery<T,IJDBCTransformer<?>> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        if(fetchSize != null){
            query.setFetchSize(fetchSize);
        }
        List<T> i = query.list();
        return i;
    }

    public <T> IScroll<T> scrollBySql(final String sql, final Object[] objs, final Type[] types,
        final Map<String, Type> returnTypes, final Integer firstResult, final Integer maxResults, final Integer fetchSize,
        final IJDBCTransformer<T> transformer) {
        // TODO Auto-generated method stub
        IQuery<T,IJDBCTransformer<?>> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        query.setFetchSize(fetchSize);
        return query.scroll();
    }

 

    public <PK> List<PK> doBatchExecuteSql(final String sql, final List<Object[]> datas, final Type[] types,
        final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        if(types == null){
            throw new DataAccessException("types参数不能为空");
        }
        
        
        IBatchDataScroll scroll = new IBatchDataScroll() {

            Iterator<Object[]> iterator = datas.iterator();

            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                // TODO Auto-generated method stub
                return iterator.next();
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return datas.size();
            }

        };
        return this.doBatchExecuteSql(sql, types, scroll, batchSize);
    }

    protected <PK> List<PK> doBatchExecuteSql(final String sql, final Type[] types, final IBatchDataScroll scroll,
        final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        IDML update = this.createSQLUpdate(sql, types, batchSize);
        return update.batchUpdate(scroll);
    }

    public <PK> List<PK> doExecuteSql(final String sql, final Object[] datas, final Type[] types) throws DataAccessException {
        Type[] typeArr = null;
        if(datas != null){
            if(types == null){
                typeArr = this.guessType(datas);
            }else{
                if(datas.length != types.length){
                    throw new DataAccessException("参数datas的长度必须和types的长度一致");
                }else{
                    typeArr = types;
                }
            }
        }
        
        IDML update = this.createSQLUpdate(sql, typeArr, null);
        return update.update(datas);
    }
    
    public <PK> List<PK> doExecuteSql(final String sql) throws DataAccessException {
       return this.doExecuteSql(sql, null, null);
    }


    public Long getCountBySql(String querySql, Object[] objs, Type[] types) {
        // TODO Auto-generated method stub
        int orderByIndex = querySql.toUpperCase().indexOf(" ORDER BY ");

        if (orderByIndex != -1) {
            querySql = querySql.substring(0, orderByIndex);
        }
        String sql;

        sql = "select count(*) as count from (" + querySql + ") tmp_count_t";

        IQuery<Object, IJDBCTransformer<?>> query =
            this.createSQLQuery(sql, objs, types, -1, -1, null, IJDBCTransformer.ONEFILED);

        List<Object> i = query.list();
        if (i.isEmpty()) {
            return null;
        }

        return (Long)i.get(0);
    }

    @Override
    public Object[] excuteProcedure(String procedureName, ProcedureParamCell... params) {
        // TODO Auto-generated method stub
        return null;
    }

    protected <T> IQuery<T, IJDBCTransformer<?>> SQLQuery(String sql) {
        // TODO Auto-generated method stub

        return new JDBCQuery(this.dataSource, dialect, sql);
    }

    protected IDML SQLUpdate(String sql) {
        // TODO Auto-generated method stub
        return new JDBCUpdate(this.dataSource, dialect, sql);
    }

   
    @Override
    public List<Map<String, Object>> queryBySql(String sql, Object[] objs) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.queryBySql(sql, objs, null, null, -1, -1, null, IJDBCTransformer.MAP);
    }



}
