package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;

public class MapJDBCTransformer extends AbstractsJDBCTransformer<Map<String,Object>> implements IJDBCTransformer<Map<String,Object>>{

	

	@Override
	protected ResultSetMapping<Map<String,Object>,ResultSet> getMapping() {
		
		return new ResultSetMapping<Map<String,Object>,ResultSet>(){

			@Override
			public Map<String, Object> mapping(ResultSet rs, LinkedHashMap<String, Type> typeMap,final IDialect dialect) {
				Map<String,Object> returnValue = new HashMap<String,Object>();
				ResultSetMetaData rsmd;
				try {
					rsmd = rs.getMetaData();
					int columnCount = rsmd.getColumnCount();
					for (int i = 1; i <= columnCount; i++) {
						String name = rsmd.getColumnLabel(i);
						if(dialect.isSystemMarkFiled(name)){
						    continue;
						}
						Type type = typeMap.get(name);
						Object value = null;
						IResourcesDataOutput<ResultSet,Integer> output = dialect.getResourcesDataOutput();
                        value = output.output(rs, type, i);
						returnValue.put(name,value);
					}
					return returnValue;
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
			
		};
	}

   
	
	
	
	
	
}
