/**
　 * <p>Title: EwkbEncoder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年7月6日
　 * @version 1.0
*/
package com.northpool.spatial.postgresql;


import java.nio.ByteOrder;

import com.northpool.commons.bits.HexUtils;
import com.northpool.spatial.AGeomEncoder;
import com.northpool.spatial.GeomEncoder;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.AbstractWkbEncoder;

/**
 * @author matt
 *
 */
@AGeomEncoder(type = SPATIAL_TYPE.hexwkb)

public class HexWkbEncoder extends AbstractWkbEncoder implements GeomEncoder<String> {

    
    public static final HexWkbEncoder ENCODER = new HexWkbEncoder();
    
 //   public static final HexWkbEncoder ENCODER_B = new HexWkbEncoder(ByteOrder.BIG_ENDIAN);
    
 //   public static final HexWkbEncoder ENCODER_L = new HexWkbEncoder(ByteOrder.LITTLE_ENDIAN);
    
  
    
    
   
    
    
    public String fromGeoBuffer(GeoBuffer geoBuffer) {
       return this.fromGeoBuffer(geoBuffer,true, ByteOrder.LITTLE_ENDIAN);
    }

   
    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        // TODO Auto-generated method stub
        Integer srid = geoBuffer.getSRID();
        if(srid == null){
            srid = 0;
        }
        geoBuffer.setSRID(srid);
        byte[] wkb = super._fromGeoBuffer(geoBuffer,byteOrder,includeSrid);
        return HexUtils.bytesToHexString(wkb);
    }

}
