/**
　 * <p>Title: AbstractDBDAO.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月4日
　 * @version 1.0
*/
package com.northpool.resources.datatable.db;

import com.northpool.commons.reflect.Bean;
import com.northpool.resources.command.Constants.OPERATION;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.db.operate.IDBTableOperator;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.ISQLQueryEngine;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.resources.sql.jdbc.JDBCGenericDaoImpl;
import com.northpool.type.Type;
import org.apache.commons.lang3.ArrayUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


/**
 * @author matt
 *
 */
public class AbstractDBDAO<PK,T> extends JDBCGenericDaoImpl implements IDAO<T,PK> {
    
    protected ITable table;
    
    protected Class<?> clazz;
    
    protected IJDBCTransformer<T> transformer; 
    
    public AbstractDBDAO(IDataSource dataSource,ITable table,IJDBCTransformer<T> transformer) {
        super(dataSource);
        this.table = table;
        this.transformer = transformer;
    }
     
    
    public ITable getTable() {
        return table;
    }


    protected void checkWriteable(){
        if(table.getIsView()){
            throw new RuntimeException(table.mark() + "为试图,不能执行写操作");
        }
    }
    
    
    
    public T get(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFiled = table.getIdField();
        QueryFilter filter = new QueryFilter();
        filter.addFilter(idFiled, OPERATION.EQ,pk);
        List<T> ii = this.query(filter);
        if(ii.isEmpty()){
            return null;
        }
        return ii.get(0);
    }

    public List<T> query(QueryFilter filter) throws DataAccessException{
        return this.query(filter, null);
    }
   
    public IScroll<T> scroll(QueryFilter filter, Integer fetchSize) throws DataAccessException{
        return this._scroll(filter, fetchSize,this.transformer);
    }
    
    private <ST> IScroll <ST> _scroll(QueryFilter filter, Integer fetchSize,IJDBCTransformer<ST> transformer) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try { 
            engine = new SQLQueryEngine(table,filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IScroll<ST> s = this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,transformer);
        return s;
    }
    
    
    public Long count(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(table,filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Long count = this.getCountBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes());
        return count;
    }
    
    public PK insert(T t) throws DataAccessException {
        return this.insert(t, false);
    }
    
    public PK insert(T t,Boolean insertNull) throws DataAccessException {
        // TODO Auto-generated method stub
        int size = this.table.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.table.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if(insertNull){
            args = new Object[size];
           
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
           //     String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, fieldName);
            }
        }else{
            List<String> newFieldInDb = new ArrayList<>(size);
            List<Object> argsList = new ArrayList<>(size);
            List<Type> typeList = new ArrayList<>(size);
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, fieldName);
                if(o != null){
                    newFieldInDb.add(fieldInDB);
                    argsList.add(o);
                    typeList.add(this.table.getFieldsInTableMap().get(fieldInDB).getType());
                }
                
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        
        
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fieldsInDB);
        List<PK> pks = this.doExecuteSql(sql, args, types);
        return pks.get(0);
    }
    
    public void remove(PK pk) throws DataAccessException {
        String idFieldName = this.table.getIdField();
        IField idField = this.table.getFieldsMap().get(idFieldName);
        String idFieldNameInDB = idField.getOriginFieldName();
        String sql = this.dialect.createDeleteSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, new Object[]{pk},new Type[]{idField.getType()});
    }
    
    public List<PK> update(T t) throws DataAccessException {
        return this.update(t, null);
    }

    public List<PK> update(T t, String[] includeFields) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.table.getIdField();
        String idFieldNameInDB = this.table.getFieldsMap().get(idFieldName).getOriginFieldName();

        int allFieldNum = this.table.fields().length;
        int size = -1;
        if (includeFields == null){
            size = allFieldNum;
        }else {
            size = includeFields.length;
            if (!ArrayUtils.contains(includeFields, idFieldName)){
                size++;
            }
        }
        String[] fieldsInDb = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int index = 0;
        for(int i = 0 ; i < allFieldNum ; i ++){
            IField field = this.table.fields()[i];
            if(field.isPK()){
                continue;
            }
            if (includeFields != null && ArrayUtils.indexOf(includeFields, field.getFieldName()) == -1) {
                continue;
            }
            fieldsInDb[index] = field.getOriginFieldName();
            types[index] = field.getType();
            args[index] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            index++;
        }
        types[size - 1] = this.table.getTableOperator().getPKColumnInfo().getType();
        args[size - 1] = Bean.getObjectValueByFieldName(t,idFieldName);
        String sql = this.dialect.createUpdateSQL( ((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fieldsInDb, idFieldNameInDB + " = ?");
        return this.doExecuteSql(sql, args,types);
    }
    
    
    public PK saveOrUpdate(T t) throws DataAccessException {
        @SuppressWarnings("unchecked")
        PK pk = (PK)Bean.getObjectValueByFieldName(t, this.table.getIdField());
        if(pk == null){
            return this.insert(t);
        }
        T inDB = this.get(pk);
        if(inDB == null){
            return this.insert(t);
        }else{
            return this.update(t).get(0);
        }
    }
    
    
    public List<T> query(QueryFilter filter, Integer fetchSize) {
        return this._query(filter, fetchSize, this.transformer);
    }
    
    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        filter.setOutputFieldNames(this.table.getIdField());
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(table,filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        
        
        return this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,IJDBCTransformer.ONEFILED);
    }
    
    
    public void update(PK pk, T t) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.table.getIdField();
        String idFieldNameInDB = this.table.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);
        
        int size = this.table.fields().length;
        
        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for(int index = 0 ; index < this.table.fieldSize() ; index ++){
            IField field = this.table.fields()[index];
            if(field.isPK()){
                continue;
            }  
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            i++;
        }
        
        types[size - 1] = this.table.getTableOperator().getPKColumnInfo().getType();
        args[size - 1] = pk;
        
        String sql = this.dialect.createUpdateSQL( ((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fields, idFieldNameInDB + " = ?");
        
        this.doExecuteSql(sql, args,types);
        
    }
    
    public List<PK> insertMany(final List<T> list,final Integer batchSize) throws DataAccessException{
        return this.insertMany(list, true, batchSize);
    }
    
    public List<PK> insertMany(final List<T> list,final Boolean insertPK,final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        int size = this.table.fields().length;
        ArrayList<String> fieldsInDBArr = new ArrayList<>();
        ArrayList<String> fieldsArr = new ArrayList<>();
        ArrayList<Type> typesArr = new ArrayList<>();
        for(int index = 0 ; index < size ; index ++){
            IField field = this.table.fields()[index];
            if(field.isPK() && !insertPK){
                continue;
            }
            fieldsInDBArr.add(field.getOriginFieldName());
            fieldsArr.add(field.getFieldName());
            typesArr.add(field.getType());
            
        }
        String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
        
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fieldsInDB);
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<T> iterator = list.iterator();
            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                T data = iterator.next();
                Object[] values = new Object[fields.length];
                // TODO Auto-generated method stub
                for(int i = 0 ; i < fields.length ; i ++){
                    String field = fields[i];
                    Object value = Bean.getObjectValueByFieldName(data, field);
                    values[i] = value;
                }
                return values;
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return list.size();
            }
            
        };
        return this.doBatchExecuteSql(sql,types, scroll, batchSize);

    }
    
    
    public List<PK> insertMany(final List<Object[]> list,final String[] fields,final Integer batchSize) throws DataAccessException{
     //   String idFieldName = this.table.getIdField();
        
        /*if(ArrayUtils.indexOf(fields, idFieldName) == -1){
            //没有在选择字段中寻找到主键，则需要报错
            throw new DataAccessException(String.format("字段中缺少主键%s",idFieldName));
        }*/
        /*int size = this.table.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.table.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }*/
        
        //List<String> fieldArr = new ArrayList<String>();
        
        String[] fieldsInDB = new String[fields.length];
        Type[] types = new Type[fields.length];
        Map<String,IField> mapField = table.getFieldsMap();
        for(int i = 0 ; i < fields.length ; i++){
            String field = fields[i];
            IField dbField = mapField.get(field);
            if(dbField == null){
                throw new RuntimeException(String.format("表:%s中没有找到字段 %s", table.mark(),field));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
            
        }
      //  return fieldArr.toArray(new String[fieldArr.size()]);
        
        //String[] fieldsInDB = this.fieldToFieldInDB(fields);
        
        
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fieldsInDB);
    
        
        return this.doBatchExecuteSql(sql, list,types, batchSize);
        
    }
    
    public IScroll<T> scroll(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.scroll(filter, null);
    }
    
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }
    
    public List<PK> insertMany(List<T> list) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.insertMany(list, null);
    }
    
    public void updateMany(T t, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    //@Override
    public void updateMany(List<Object[]> list, String[] fields, List<PK> ids, Integer batchSize) throws DataAccessException {
        int size = fields.length;

      /*  String[] fieldsInDB = new String[size];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        Map<String,IField> mapField = table.getFieldsMap();
        for(int i = 0 ; i < size ; i++){
            String field = fields[i];
            IField dbField = mapField.get(field);
            if(dbField == null){
                throw new RuntimeException(String.format("表:%s中没有找到字段 %s", table.mark(),field));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field);


        }


        String idFieldName = this.table.getIdField();
        String idFieldNameInDB = this.table.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);


        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        int i = 0;
        for(int index = 0 ; index < this.table.fieldSize() ; index ++){
            IField field = this.table.fields()[index];
            if(field.isPK()){
                continue;
            }
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            i++;
        }

        types[size - 1] = this.table.getTableOperator().getPKColumnInfo().getType();
        args[size - 1] = pk;

        String sql = this.dialect.createUpdateSQL( ((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fields, idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, args,types);

        //  return fieldArr.toArray(new String[fieldArr.size()]);

        //String[] fieldsInDB = this.fieldToFieldInDB(fields);


        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(),this.table.getTablename(), fieldsInDB);


        this.doBatchExecuteSql(sql, list,types, batchSize);*/
    }

    public void remove(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }
    
    
    private <QT> List<QT> _query(QueryFilter filter, Integer fetchSize,IJDBCTransformer<QT> transformer) throws DataAccessException {
        
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(table,filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        List<QT> i = this.queryBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes(), parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,transformer);
        return i;
    }
   
    public List<Object[]> queryArray(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        
         return this._query(filter, fetchSize, IJDBCTransformer.ARRAY);
    }

   
    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return this._scroll(queryFilter, fetchSize, IJDBCTransformer.ARRAY);
    }
    
    
    
}
