/**
　 * <p>Title: AbstractResourcesDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月23日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypeDouble;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeLong;
import com.northpool.type.TypeString;
import com.northpool.type.TypeTimestamp;
/**
 * @author matt
 *
 */
public abstract class AbstractResourcesDataInput implements IResourcesDataInput<PreparedStatement,Integer>{

   
  

    
    @Override
    public void columnBoolean(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName,  Types.BOOLEAN);
            return;
        }
        if(TypeBoolean.INSTANCE.isType(value)){
            input.setBoolean(indexOrLabelName, (boolean)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeBoolean.INSTANCE,value,"值类型不符");
        }
        
    }

  
    @Override
    public void columnBigDecimal(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName,  Types.NUMERIC);
            return;
        }
        if(TypeBigDecimal.INSTANCE.isType(value)){
            input.setBigDecimal(indexOrLabelName, (BigDecimal)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeBigDecimal.INSTANCE,value,"值类型不符");
        }
    }

    
    @Override
    public void columnBytes(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.BLOB);
            return;
        }
        if(TypeBytes.INSTANCE.isType(value)){
            input.setBytes(indexOrLabelName,(byte[])value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeBytes.INSTANCE,value,"值类型不符");
        }
        
    }

   
    @Override
    public void columnDouble(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        // TODO Auto-generated method stub
        if(value == null){
            input.setNull(indexOrLabelName, Types.DOUBLE);
            return;
        }
        if(TypeDouble.INSTANCE.isType(value)){
            input.setDouble(indexOrLabelName,(double)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeDouble.INSTANCE,value,"值类型不符");
        }
    }

  
    @Override
    abstract public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception ;

    
    @Override
    public void columnInteger(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.INTEGER);
            return;
        }
        if(TypeInteger.INSTANCE.isType(value)){
            input.setInt(indexOrLabelName,(int)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeInteger.INSTANCE,value,"值类型不符");
        }
        
    }

   
    @Override
    public void columnLong(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.BIGINT);
            return;
        }
        if(TypeLong.INSTANCE.isType(value)){
            input.setLong(indexOrLabelName,(long)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeLong.INSTANCE,value,"值类型不符");
        }
        
    }

   
    @Override
    public void columnString(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.VARCHAR);
            return;
        }
        if(TypeString.INSTANCE.isType(value)){
            input.setString(indexOrLabelName,(String)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeString.INSTANCE,value,"值类型不符");
        }
        
    }

   
    @Override
    public void columnTimestamp(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.TIMESTAMP);
            return;
        }
        if(TypeTimestamp.INSTANCE.isType(value)){
            Timestamp st = new Timestamp(((Date)value).getTime());
            input.setTimestamp(indexOrLabelName,st);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeTimestamp.INSTANCE,value,"值类型不符");
        }
        
    }

}
