/**
　 * <p>Title: PostgresSQLResourcesDataOutput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.oracle;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.db.AbstractResourcesDataOutput;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Geom;
import oracle.jdbc.internal.OracleStruct;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.*;

/**
 * @author matt
 *
 */
public class OracleResourcesDataOutput extends AbstractResourcesDataOutput implements  IResourcesDataOutput<ResultSet,Integer> {

    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.oracle;
    }

  
    @Override
    public Geom columnGeometry(ResultSet output, Integer indexOrLabelName) throws Exception {

        OracleStruct oracleStruct = (OracleStruct)output.getObject(indexOrLabelName);
        if(oracleStruct == null){
            return null;
        }
        Geom m = new Geom(SPATIAL_TYPE.sdo,oracleStruct);
        return m;
    }


    @Override
    public byte[] columnBytes(ResultSet output, Integer indexOrLabelName) throws Exception{
        Object object = output.getObject(indexOrLabelName);
        if (object instanceof Blob){
            Blob blob = (Blob) object;
            if(blob != null){
                return blobToBytes(blob);
            }
        }else if (object instanceof Clob){

        }else if (object instanceof NClob){

        }

        return null;
    }

    private byte[] blobToBytes(Blob blob) throws IOException, SQLException {

        try(BufferedInputStream is = new BufferedInputStream(blob.getBinaryStream())) {
            byte[] bytes = new byte[(int) blob.length()];
            int len = bytes.length;
            int offset = 0;
            int read = 0;

            while (offset < len && (read = is.read(bytes, offset, len - offset)) >= 0) {
                offset += read;
            }
            return bytes;
        }
    }
}
