/**
　 * <p>Title: PostgresSQLResourcesDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.postgresql;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.resources.dialect.db.AbstractResourcesDataInput;
import com.northpool.spatial.Geom;
import com.northpool.type.TypePostGisGeometry;
import com.northpool.type.TypeString;
import org.postgresql.util.PGobject;

import java.sql.PreparedStatement;
import java.sql.Types;

/**
 * @author matt
 *
 */
public class PostgresSQLResourcesDataInput extends AbstractResourcesDataInput implements IResourcesDataInput<PreparedStatement,Integer>{

    static final String POSTGIS_GEOMETRY_NAME = "geometry";
    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.postgreSQL;
    }

   
    @Override
    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName,  Types.JAVA_OBJECT);
            return;
        }
        if(value instanceof Geom){
            Geom geom = (Geom)value;
            TypePostGisGeometry.INSTANCE.isType(geom);
            PGobject po = new PGobject();
            po.setType(POSTGIS_GEOMETRY_NAME);
           
            po.setValue((String)geom.getOriginGeom());
            input.setObject(indexOrLabelName, po);
         }else{
             throw new ResourcesDataInputException(this.getDataSourceType(),TypePostGisGeometry.INSTANCE,value,"值类型不符");
         }
    }


    @Override
    public void columnString(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName, Types.VARCHAR);
            return;
        }
        if(TypeString.INSTANCE.isType(value)){
            String strValue = (String) value;
            if (strValue.indexOf("''") != -1){//postgresql driver已经处理了转义符，这里正常写就行
                strValue = strValue.replaceAll("''", "'");
            }
            input.setString(indexOrLabelName, strValue);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeString.INSTANCE,value,"值类型不符");
        }

    }


}
