/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.db.operate.column;

import com.northpool.commons.util.Functions;
import com.northpool.resources.datatable.db.operate.OracleTableOperator;
import com.northpool.resources.datatable.db.operate.column.AbstractDBColumn;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.Constants;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeInteger;

public class OracleColumn
extends AbstractDBColumn
implements IColumn {
    protected OracleTableOperator oracleTableBuilder;

    public OracleColumn(String columnName, int columnSize, int digits, String columnTypeName, boolean nullable, String defaultValue, String remarks, ISQLDialect sqlDialect) {
        super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks, (IDialect)sqlDialect);
    }

    protected void initAttType() {
        this.type = Functions.hasMask((String)this.columnTypeName, (String)"NUMBER") || Functions.hasMask((String)this.columnTypeName, (String)"NUMERIC") ? (this.columnSize <= 10 ? TypeInteger.INSTANCE : TypeBigDecimal.INSTANCE) : this.dialect.getTypeByName(this.columnTypeName);
        if (Functions.hasMask((String)this.columnTypeName, (String)"GEOMETRY")) {
            this.isSpatial = true;
        }
    }

    public Constants.SPATIAL_TYPE getSpatialType() {
        return Constants.SPATIAL_TYPE.sdo;
    }
}

