/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.postgresql;

import com.northpool.spatial.AGeomDecoder;
import com.northpool.spatial.ByteOrderDataInStream;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomDecoder;
import com.northpool.spatial.GeometryInfo;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.AbstractWkbDecoder;
import java.io.ByteArrayInputStream;

@AGeomDecoder(type=Constants.SPATIAL_TYPE.hexwkb)
public class HexWkbDecoder
extends AbstractWkbDecoder
implements GeomDecoder<String> {
    public static final HexWkbDecoder DECODER = new HexWkbDecoder();

    public GeoBuffer toGeoBuffer(String hex) throws Exception {
        ByteArrayInputStream instream = new ByteArrayInputStream(hex.getBytes());
        ByteOrderDataInStream dis = new ByteOrderDataInStream(instream, true);
        byte byteOrderWKB = dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        dis.setOrder(byteOrder);
        int typeInt = dis.readInt();
        GeometryInfo info = new GeometryInfo();
        info.setGeometryType(typeInt & 0x1FFFFFFF);
        info.setHasZ((typeInt & Integer.MIN_VALUE) != 0);
        info.setHasM((typeInt & 0x40000000) != 0);
        boolean haveSrid = (typeInt & 0x20000000) != 0;
        int srid = 0;
        if (haveSrid) {
            srid = dis.readInt();
        }
        int size = instream.available();
        Constants.GEO_TYPE geoType = this.is(info.getGeometryType());
        int inputDimension = info.hasZ() ? 3 : 2;
        GeoBuffer geo = new GeoBuffer(geoType, srid, inputDimension);
        return this.process(geoType, dis, geo, info);
    }
}

