/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.resources.sql.jdbc.AbstractsJDBCTransformer;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.type.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.LinkedHashMap;

public class ArrayJDBCTransformer
extends AbstractsJDBCTransformer<Object[]>
implements IJDBCTransformer<Object[]> {
    @Override
    protected ResultSetMapping<Object[], ResultSet> getMapping() {
        return new ResultSetMapping<Object[], ResultSet>(){

            public Object[] mapping(ResultSet rs, LinkedHashMap<String, Type> typeMap, IDialect dialect) {
                int systemFiledNum = 0;
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    Object[] values = new Object[columnCount];
                    for (int i = 1; i <= columnCount; ++i) {
                        String name = rsmd.getColumnLabel(i);
                        if (dialect.isSystemMarkFiled(name)) {
                            ++systemFiledNum;
                            continue;
                        }
                        Type type = typeMap.get(name);
                        Object value = null;
                        IResourcesDataOutput output = dialect.getResourcesDataOutput();
                        values[i - 1 - systemFiledNum] = value = output.output((Object)rs, type, (Object)i);
                    }
                    if (systemFiledNum == 0) {
                        return values;
                    }
                    Object[] valuesNew = new Object[columnCount - systemFiledNum];
                    System.arraycopy(values, 0, valuesNew, 0, columnCount - systemFiledNum);
                    return valuesNew;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

