/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.oracle;

import com.northpool.commons.util.BuilderCreator;
import com.northpool.commons.util.DoubleBuilder;
import com.northpool.spatial.AGeomDecoder;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomDecoder;
import com.northpool.spatial.GeometryInfo;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.geofeature.GeoPart;
import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleStruct;
import oracle.sql.Datum;

@AGeomDecoder(type=Constants.SPATIAL_TYPE.sdo)
public class OracleDecoder
implements GeomDecoder<Object> {
    protected static final int UNKNOWN = 0;
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int COLLECTION = 4;
    protected static final int MULTIPOINT = 5;
    protected static final int MULTILINESTRING = 6;
    protected static final int MULTIPOLYGON = 7;
    protected static OracleDecoder _decoder = new OracleDecoder();

    public static OracleDecoder decoder() {
        return _decoder;
    }

    public GeometryInfo buildGeometryTypeAndZM(Integer sdoGtype) throws IOException {
        GeometryInfo info = new GeometryInfo();
        String gtype = sdoGtype.toString();
        if (gtype.length() != 4) {
            throw new RuntimeException("sdoGtype" + sdoGtype + "\u957f\u5ea6\u4e0d\u4e3a4");
        }
        if (gtype.charAt(0) == '3') {
            info.hasZ = true;
        }
        if (gtype.charAt(0) == '4') {
            info.hasM = true;
        }
        info.geometryType = Integer.valueOf(gtype.substring(2, 4));
        return info;
    }

    public GeoBuffer toGeoBuffer(Object value) throws Exception {
        if (value instanceof GeoBuffer) {
            return (GeoBuffer)value;
        }
        OracleStruct struct = (OracleStruct)value;
        Datum[] data = null;
        int type = 2000;
        data = struct.getOracleAttributes();
        type = data[0].intValue();
        GeometryInfo info = this.buildGeometryTypeAndZM(type);
        Integer srid = null;
        if (data[1] != null) {
            srid = data[1].intValue();
        }
        int size = Long.valueOf(struct.getLength()).intValue();
        Constants.GEO_TYPE geoType = this.is(info.geometryType);
        int inputDimension = info.hasZ() ? 3 : 2;
        GeoBuffer geo = new GeoBuffer(geoType, srid.intValue(), inputDimension);
        switch (geoType) {
            case POINT: {
                this.dealWithPoint(struct, geo, info);
                break;
            }
            case LINESTRING: {
                OracleArray datasarray = (OracleArray)data[4];
                this.dealWithLineString(datasarray.getDoubleArray(), geo, info);
                break;
            }
            case POLYGON: {
                this.dealWithPolygon(data, geo, info);
                break;
            }
            case MULTIPOINT: {
                this.dealWithMultiPoint(data, geo, info);
                break;
            }
            case MULTILINESTRING: {
                this.dealWithMultiLine(data, geo, info);
                break;
            }
            case MULTIPOLYGON: {
                this.dealWithMultiPolygon(data, geo, info);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geoType.name());
            }
        }
        return geo;
    }

    public Constants.GEO_TYPE is(int type) {
        switch (type) {
            case 1: {
                return Constants.GEO_TYPE.POINT;
            }
            case 2: {
                return Constants.GEO_TYPE.LINESTRING;
            }
            case 3: {
                return Constants.GEO_TYPE.POLYGON;
            }
            case 4: {
                return Constants.GEO_TYPE.COLLECTION;
            }
            case 5: {
                return Constants.GEO_TYPE.MULTIPOINT;
            }
            case 6: {
                return Constants.GEO_TYPE.MULTILINESTRING;
            }
            case 7: {
                return Constants.GEO_TYPE.MULTIPOLYGON;
            }
        }
        throw new RuntimeException("\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b" + type);
    }

    private void dealWithPoint(OracleStruct struct, GeoBuffer geo, GeometryInfo info) throws SQLException {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        Object[] data = null;
        data = struct.getAttributes();
        OracleStruct point = (OracleStruct)data[2];
        if (point == null) {
            OracleArray datasarray = (OracleArray)data[4];
            double[] datasords = datasarray.getDoubleArray();
            x = datasords[0];
            y = datasords[1];
            if (info.hasZ) {
                z = datasords[2];
            }
        } else {
            Datum[] xyz = point.getOracleAttributes();
            x = xyz[0].doubleValue();
            y = xyz[1].doubleValue();
            if (info.hasZ) {
                z = xyz[2].doubleValue();
            }
        }
        geo.addPoint(x, y, z);
    }

    private void dealWithMultiPoint(Datum[] data, GeoBuffer geo, GeometryInfo info) throws Exception {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] dataords = null;
        OracleArray datasarray = (OracleArray)data[4];
        dataords = datasarray.getDoubleArray();
        int nums = dataords.length / 2;
        for (int i = 0; i < nums; ++i) {
            x = dataords[2 * i];
            y = dataords[2 * i + 1];
            geo.addPoint(x, y, z);
        }
    }

    private double[] readPointArray(double[] data, DoubleBuilder doubleBuilder, GeometryInfo info) throws SQLException {
        double[] datasords = data;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        int count = datasords.length;
        int inputDimension = info.hasZ() ? 3 : 2;
        for (int i = 0; i < count / inputDimension; ++i) {
            double x = datasords[i * inputDimension];
            double y = datasords[i * inputDimension + 1];
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y < minY) {
                minY = y;
            }
            doubleBuilder.append(x);
            doubleBuilder.append(y);
            if (info.hasZ) {
                double z = datasords[i * inputDimension + 2];
                doubleBuilder.append(z);
            }
            if (!info.hasM) continue;
            double d = datasords[i * inputDimension + 3];
        }
        doubleBuilder.trimToSize();
        return new double[]{minX, minY, maxX, maxY};
    }

    private void dealWithLineString(double[] data, GeoBuffer geo, GeometryInfo info) throws SQLException {
        DoubleBuilder doubleBuilder = BuilderCreator.createDouble((int)data.length);
        double[] bbox = this.readPointArray(data, doubleBuilder, info);
        geo.addLinePart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    private void dealWithMultiLine(Datum[] data, GeoBuffer geo, GeometryInfo info) throws SQLException {
        double[] dataords = null;
        int[] struct = null;
        OracleArray structarray = (OracleArray)data[3];
        OracleArray datasarray = (OracleArray)data[4];
        struct = structarray.getIntArray();
        dataords = datasarray.getDoubleArray();
        int previousIndex = 0;
        for (int i = 0; i < struct.length; i += 3) {
            int beginIndex = struct[i] - 1;
            int inout = struct[i + 1];
            int endIndex = -1;
            if (i + 3 < struct.length) {
                endIndex = struct[i + 3] - 1;
            }
            if (inout != 1003 && inout != 2 && inout != 2003) continue;
            previousIndex = inout;
            double[] dataDouble = null;
            int length = 0;
            length = endIndex != -1 ? endIndex - beginIndex : dataords.length - beginIndex;
            dataDouble = new double[length];
            System.arraycopy(dataords, beginIndex, dataDouble, 0, length);
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble((int)length);
            double[] bbox = this.readPointArray(dataDouble, doubleBuilder, info);
            if (inout == 2) {
                geo.addLinePart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3]);
                continue;
            }
            if (inout == 1003) {
                geo.addPolygonPart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3], GeoPart.RING_TYPE.outside);
                continue;
            }
            geo.addPolygonPart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3], GeoPart.RING_TYPE.inside);
        }
    }

    private void dealWithPolygon(Datum[] data, GeoBuffer geo, GeometryInfo info) throws SQLException {
        this.dealWithMultiLine(data, geo, info);
    }

    private void dealWithMultiPolygon(Datum[] data, GeoBuffer geo, GeometryInfo info) throws SQLException {
        this.dealWithMultiLine(data, geo, info);
    }
}

