/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.db.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datatable.db.operate.AbstractDBTableOperator;
import com.northpool.resources.datatable.db.operate.IDBTableOperator;
import com.northpool.resources.datatable.db.operate.column.PostgresColumn;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.spatial.Constants;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@ATableOperator(name="postgresql", type=Constants.DATA_SOURCE_TYPE.postgreSQL)
public class PostgresTableOperator
extends AbstractDBTableOperator
implements IDBTableOperator {
    protected static final String DEFAULT_PG_SCHEMA = "public";

    @Override
    protected void processTableNameAndSchema(String tableName, String schema, Boolean isCaseSensitive) {
        if (tableName.contains(".")) {
            String[] arr = tableName.split("\\.");
            tableName = arr[1];
            schema = arr[0];
        }
        if (schema == null) {
            schema = DEFAULT_PG_SCHEMA;
        }
        if (!isCaseSensitive.booleanValue()) {
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
        this.tableName = tableName;
        this.schema = schema;
    }

    @Override
    protected String getRemarks(ResultSet columns) throws SQLException {
        return columns.getString("REMARKS");
    }

    @Override
    protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
        ResultSet columns = dbmd.getColumns(this.cataLog, this.schema, this.tableName.replace("\"", ""), null);
        return columns;
    }

    @Override
    protected IColumn createColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, String defaultValue, String remarks) {
        PostgresColumn column = new PostgresColumn(columnName, (int)columnSize, (int)digits, columnTypeName, (boolean)nullable, defaultValue, remarks, this.dialect);
        return column;
    }

    protected Object[] getSpatialInfo(String colunmName) throws SQLException {
        Constants.GEO_TYPE[] values;
        String sql = "select srid,type from geometry_columns where f_table_catalog = ? and f_table_schema = ? and f_table_name = ? and f_geometry_column = ?";
        List<Map<String, Object>> i = this.genericDao.queryBySql(sql, new Object[]{this.cataLog, this.schema, this.tableName, colunmName}, null, null, null, null, null, IJDBCTransformer.MAP);
        if (i.isEmpty()) {
            return null;
        }
        Map<String, Object> data = i.get(0);
        Integer srid = (Integer)data.get("srid");
        String type = (String)data.get("type");
        Constants.GEO_TYPE gtype = Constants.GEO_TYPE.GEOMETRY;
        for (Constants.GEO_TYPE geo_type : values = Constants.GEO_TYPE.values()) {
            if (!geo_type.name().equalsIgnoreCase(type)) continue;
            gtype = geo_type;
        }
        return new Object[]{srid, gtype};
    }

    @Override
    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        String indexName = this.createSpatialIndexName(colname);
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + "_" + colname + "\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15");
            String indexName1 = indexName;
            String tableName = this.tableName;
            String colname1 = colname;
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                tableName = "\"" + tableName + "\"";
                indexName1 = "\"" + indexName1 + "\"";
                colname1 = "\"" + colname1 + "\"";
            }
            String sql = "CREATE INDEX " + indexName1 + " ON " + tableName + "USING gist (" + colname1 + ");";
            this.genericDao.doExecuteSql(sql, null, null);
            Index index = new Index();
            index.setName(indexName);
            index.setUnique(Boolean.valueOf(false));
            index.isSpatial(Boolean.valueOf(true));
            index.setColname(colname);
            this.addToIndexMap(colname, (IIndex)index);
            return null;
        });
        return promise;
    }
}

