/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.oracle;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.db.AbstractResourcesDataOutput;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Geom;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.internal.OracleStruct;

public class OracleResourcesDataOutput
extends AbstractResourcesDataOutput
implements IResourcesDataOutput<ResultSet, Integer> {
    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.oracle;
    }

    @Override
    public Geom columnGeometry(ResultSet output, Integer indexOrLabelName) throws Exception {
        OracleStruct oracleStruct = (OracleStruct)output.getObject(indexOrLabelName);
        if (oracleStruct == null) {
            return null;
        }
        Geom m = new Geom(Constants.SPATIAL_TYPE.sdo, (Object)oracleStruct);
        return m;
    }

    @Override
    public byte[] columnBytes(ResultSet output, Integer indexOrLabelName) throws Exception {
        Object object = output.getObject(indexOrLabelName);
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            if (blob != null) {
                return this.blobToBytes(blob);
            }
        } else if (object instanceof Clob || object instanceof NClob) {
            // empty if block
        }
        return null;
    }

    private byte[] blobToBytes(Blob blob) throws IOException, SQLException {
        try (BufferedInputStream is = new BufferedInputStream(blob.getBinaryStream());){
            byte[] bytes = new byte[(int)blob.length()];
            int len = bytes.length;
            int read = 0;
            for (int offset = 0; offset < len && (read = is.read(bytes, offset, len - offset)) >= 0; offset += read) {
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

