/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.resources.sql.jdbc.AbstractsJDBCTransformer;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.type.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapJDBCTransformer
extends AbstractsJDBCTransformer<Map<String, Object>>
implements IJDBCTransformer<Map<String, Object>> {
    @Override
    protected ResultSetMapping<Map<String, Object>, ResultSet> getMapping() {
        return new ResultSetMapping<Map<String, Object>, ResultSet>(){

            public Map<String, Object> mapping(ResultSet rs, LinkedHashMap<String, Type> typeMap, IDialect dialect) {
                HashMap<String, Object> returnValue = new HashMap<String, Object>();
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        String name = rsmd.getColumnLabel(i);
                        if (dialect.isSystemMarkFiled(name)) continue;
                        Type type = typeMap.get(name);
                        Object value = null;
                        IResourcesDataOutput output = dialect.getResourcesDataOutput();
                        value = output.output((Object)rs, type, (Object)i);
                        returnValue.put(name, value);
                    }
                    return returnValue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

