/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.resources.sql.jdbc.AbstractsJDBCCell;
import com.northpool.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JDBCUpdate
extends AbstractsJDBCCell<Void>
implements IDML {
    protected int batchSize = 40;

    public JDBCUpdate(IDataSource dataSource, ISQLDialect dialect, String sql) {
        super(dataSource, dialect, sql);
    }

    protected void printSQL(Object[] args, Integer batchSize) {
        if (batchSize != null) {
            logger.debug(this.sql);
            logger.debug("use parameters:" + StringUtils.join((Object[])args, (String)","));
        } else {
            logger.debug(this.sql);
            logger.debug("use parameters size " + batchSize);
        }
    }

    public <PK> List<PK> update(Object[] args) throws DataAccessException {
        try {
            return this.execute(con -> this.prepareUpdateStatement(con), ps -> {
                try {
                    ArrayList<Object> returnIds = new ArrayList<Object>();
                    if (args != null) {
                        this.setValues(ps, args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                    }
                    ps.execute();
                    ResultSet generatedKeys = ps.getGeneratedKeys();
                    while (generatedKeys.next()) {
                        Object id = generatedKeys.getObject(1);
                        returnIds.add(id);
                    }
                    return returnIds;
                }
                catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if (!isAutoCommit.booleanValue()) {
                        ps.getConnection().rollback();
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            });
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
    }

    public <PK> List<PK> batchUpdate(IBatchDataScroll scroll) throws DataAccessException {
        try {
            return this.execute(con -> this.prepareUpdateStatement(con), ps -> {
                try {
                    ArrayList<Object> returnIds = new ArrayList<Object>();
                    int index = 0;
                    while (scroll.hasNext()) {
                        Object[] args = scroll.next();
                        this.setValues(ps, args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                        ps.addBatch();
                        if ((index + 1) % this.batchSize == 0) {
                            ps.executeBatch();
                            ResultSet generatedKeys = ps.getGeneratedKeys();
                            while (generatedKeys.next()) {
                                Object id = generatedKeys.getObject(1);
                                returnIds.add(id);
                            }
                        }
                        ++index;
                    }
                    if (scroll.size() % this.batchSize != 0) {
                        ps.executeBatch();
                        ResultSet generatedKeys = ps.getGeneratedKeys();
                        while (generatedKeys.next()) {
                            Object id = generatedKeys.getObject(1);
                            returnIds.add(id);
                        }
                    }
                    return returnIds;
                }
                catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if (!isAutoCommit.booleanValue()) {
                        ps.getConnection().rollback();
                    }
                    UException.printStackTrace((Throwable)e);
                    throw new SQLException(e);
                }
            });
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
    }

    public IDML setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    protected final PreparedStatement prepareUpdateStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.sql, 1);
        if (connection.getTransactionIsolation() == 0) {
            connection.setAutoCommit(true);
        }
        return preparedStatement;
    }

    public <PK> PK insert(Object[] args) throws DataAccessException {
        List<PK> update = this.update(args);
        return update.get(0);
    }

    public <PK> List<PK> batchInsert(IBatchDataScroll scroll) throws DataAccessException {
        return this.batchUpdate(scroll);
    }
}

