/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datasource.db.JDBCPoolManager;
import com.northpool.resources.sql.jdbc.SingleConnectionDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;

public class Transactions {
    static final ThreadLocal<HashMap<String, SingleConnectionDataSource>> SINGLE_CONNECTION_IN_THREAD = new ThreadLocal();

    public static void begin(DbDataSource dbDataSource) throws SQLException {
        SingleConnectionDataSource dataSource = Transactions._useSingleConnectionInThread(dbDataSource);
        dataSource.getConnection().setAutoCommit(false);
        dataSource.isTransactionActive = true;
    }

    public static boolean isTransactionActive(DbDataSource dbDataSource) {
        DataSource dataSource = Transactions.getThreadDataSource(dbDataSource);
        if (dataSource == null) {
            return false;
        }
        SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
        return sds.isTransactionActive();
    }

    public static void commit(DbDataSource dbDataSource) throws SQLException {
        DataSource dataSource = Transactions.getThreadDataSource(dbDataSource);
        try {
            dataSource.getConnection().commit();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                dataSource.getConnection().setAutoCommit(true);
                SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
                sds.isTransactionActive = false;
                Transactions.connectionInThreadRelease(dbDataSource);
                throw throwable;
            }
        }
        dataSource.getConnection().setAutoCommit(true);
        SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
        sds.isTransactionActive = false;
        Transactions.connectionInThreadRelease(dbDataSource);
    }

    public static void rollback(DbDataSource dbDataSource) throws SQLException {
        DataSource dataSource = Transactions.getThreadDataSource(dbDataSource);
        try {
            dataSource.getConnection().rollback();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                dataSource.getConnection().setAutoCommit(true);
                SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
                sds.isTransactionActive = false;
                Transactions.connectionInThreadRelease(dbDataSource);
                throw throwable;
            }
        }
        dataSource.getConnection().setAutoCommit(true);
        SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
        sds.isTransactionActive = false;
        Transactions.connectionInThreadRelease(dbDataSource);
    }

    static SingleConnectionDataSource _useSingleConnectionInThread(DbDataSource dbDataSource) {
        Connection connection;
        HashMap<String, SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if (map == null) {
            map = new HashMap();
            SINGLE_CONNECTION_IN_THREAD.set(map);
        }
        DataSource dataSource = JDBCPoolManager.getInstance().getPool(dbDataSource);
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        SingleConnectionDataSource data = new SingleConnectionDataSource(connection);
        map.put(dbDataSource.mark(), data);
        return data;
    }

    public static void useSingleConnectionInThread(DbDataSource dbDataSource) {
        Transactions._useSingleConnectionInThread(dbDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connectionInThreadRelease(DbDataSource dbDataSource) {
        HashMap<String, SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if (map == null) {
            return;
        }
        DataSource dataSource = map.get(dbDataSource.mark());
        if (dataSource == null) {
            return;
        }
        if (dataSource != null) {
            try {
                dataSource.getConnection().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                map.remove(dbDataSource.mark());
            }
        }
    }

    static DataSource getThreadDataSource(DbDataSource dbDataSource) {
        HashMap<String, SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if (map == null) {
            return null;
        }
        DataSource dataSource = map.get(dbDataSource.mark());
        return dataSource;
    }
}

