/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.oracle;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.resources.dialect.db.AbstractResourcesDataInput;
import com.northpool.spatial.Geom;
import com.northpool.spatial.oracle.GeometryOracleConverter;
import com.northpool.spatial.oracle.OracleConnectionFinder;
import com.northpool.type.Type;
import com.northpool.type.TypePostGisGeometry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.STRUCT;

public class OracleResourcesDataInput
extends AbstractResourcesDataInput
implements IResourcesDataInput<PreparedStatement, Integer> {
    static final String POSTGIS_GEOMETRY_NAME = "geometry";

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.postgreSQL;
    }

    @Override
    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 2000);
            return;
        }
        if (!(value instanceof Geom)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypePostGisGeometry.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Geom geom = (Geom)value;
        OracleConnection con = OracleConnectionFinder.getInstance().find(input.getConnection());
        GeometryOracleConverter gc = new GeometryOracleConverter((Connection)con);
        STRUCT sdo = gc.toSDO(geom.toJTSGeometry());
        input.setObject(indexOrLabelName, sdo);
    }
}

