/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.db;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.PasswordCrypo;
import com.northpool.resources.datasource.db.JDBCPoolManager;
import com.northpool.resources.sql.jdbc.IJDBCGenericDao;
import com.northpool.resources.sql.jdbc.JDBCGenericDaoImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@ADataSource(name="db", types="oracle,postgreSQL,kingbase,highgo,mysql,mysql8.0")
public class DbDataSource
extends AbstractDataSource
implements IDataSource {
    protected String url;
    protected String user;
    @Deprecated
    protected String password;
    protected String crypoPassword;
    protected Connection dbconn = null;
    protected String poolName = "default_pool";

    DbDataSource() {
    }

    public DbDataSource(String id, String url, String user, String password, Constants.DATA_SOURCE_TYPE dataSourceType) {
        this.id = id;
        this.url = url;
        this.user = user;
        if (password != null) {
            this.crypoPassword = PasswordCrypo.encode((String)password);
        }
        this.dataSourceType = dataSourceType;
    }

    public String getCrypoPassword() {
        return this.crypoPassword;
    }

    public void setCrypoPassword(String crypoPassword) {
        this.crypoPassword = crypoPassword;
    }

    public DbDataSource(String url, String user, String password, Constants.DATA_SOURCE_TYPE dataSourceType) {
        this.url = url;
        this.user = user;
        if (password != null) {
            this.crypoPassword = PasswordCrypo.encode((String)password);
        }
        this.dataSourceType = dataSourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id == null ? this.mark() : this.id;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public Connection getDbconn() {
        return this.dbconn;
    }

    public void setDbconn(Connection dbconn) {
        this.dbconn = dbconn;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.mark();
    }

    public String mark() {
        if (this.crypoPassword != null) {
            return this.dataSourceType.name() + '_' + this.processURL(this.url) + '_' + this.user + "_" + this.crypoPassword;
        }
        return this.dataSourceType.name() + '_' + this.processURL(this.url) + '_' + this.user;
    }

    protected String processURL(String url) {
        url = url.replaceAll("\\/", "@");
        return url;
    }

    protected String password() {
        if (this.password != null) {
            return this.password;
        }
        return PasswordCrypo.decode((String)this.crypoPassword);
    }

    public DbDataSource getDbDataSourcePool(String poolName) {
        DbDataSource dbDataSource = new DbDataSource(this.id, this.url, this.user, this.password(), this.dataSourceType);
        dbDataSource.poolName = poolName;
        return dbDataSource;
    }

    public DataSource connection() {
        DataSource dataSource = JDBCPoolManager.getInstance().getPool(this);
        return dataSource;
    }

    public synchronized void resetConnection() {
        JDBCPoolManager.getInstance().remove(this.dataSourceType, this.url, this.user, this.password());
    }

    public synchronized void destory() {
        JDBCPoolManager.getInstance().remove(this.dataSourceType, this.url, this.user, this.password());
    }

    public IJDBCGenericDao genericDao() {
        return new JDBCGenericDaoImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ResultSet getSqlQuery(String sql) {
        Statement statement = null;
        try {
            ResultSet resultSet;
            if (this.dbconn == null) {
                this.dbconn = this.connection().getConnection();
            }
            if ((resultSet = (statement = this.dbconn.createStatement()).executeQuery(sql)).wasNull()) {
                throw new RuntimeException("\u83b7\u53d6\u8868\u96c6\u5408\u5931\u8d25");
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    this.dbconn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean executeSqlCommand(String sql) {
        Statement statement = null;
        try {
            if (this.dbconn == null) {
                this.dbconn = this.connection().getConnection();
            }
            statement = this.dbconn.createStatement();
            boolean execute = statement.execute(sql);
            Boolean bl = execute;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                    this.dbconn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void testConnection() throws Exception {
        JDBCPoolManager.getInstance().inValid(this.dataSourceType, this.url, this.user, this.password());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DbDataSource that = (DbDataSource)((Object)o);
        return new EqualsBuilder().append((Object)this.url, (Object)that.url).append((Object)this.user, (Object)that.user).append((Object)this.password(), (Object)that.password()).append((Object)this.dataSourceType, (Object)that.dataSourceType).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.url).append((Object)this.user).append((Object)this.password()).append((Object)this.dataSourceType).toHashCode();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

