/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.northpool.commons.reflect.Bean;
import com.northpool.commons.reflect.Function;
import com.northpool.commons.util.MD5;
import com.northpool.diagnose.GlobalMetrics;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.exception.CommonException;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datasource.db.JDBCPoolEnum;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPoolManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static JDBCPoolManager INSTANCE = new JDBCPoolManager();
    protected static HashMap<String, DataSource> POOL_CACHE = new HashMap();
    static final Integer TEST_CONNECT_TIMEOUT = 5;
    protected static HashMap<String, DBPoolParameter> POOL_PARAMETER_MAP = new HashMap();

    public static JDBCPoolManager getInstance() {
        return INSTANCE;
    }

    public DataSource getPool(DbDataSource dbDataSource) {
        String poolName = dbDataSource.poolName;
        DBPoolParameter parameter = POOL_PARAMETER_MAP.get(poolName);
        if (parameter == null) {
            throw new RuntimeException("\u6ca1\u6709\u540d\u4e3a " + poolName + " \u7684\u6570\u636e\u5e93\u6c60\u53c2\u6570");
        }
        return this.getDataSource(dbDataSource.getDataSourceType(), dbDataSource.getUrl(), dbDataSource.getUser(), dbDataSource.password(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource(Constants.DATA_SOURCE_TYPE type, String url, String user, String password, DBPoolParameter parameter) {
        String key = this.getPoolAliasName(type, url, user, password, parameter);
        DataSource pool = POOL_CACHE.get(key);
        if (pool != null) {
            return pool;
        }
        JDBCPoolManager jDBCPoolManager = this;
        synchronized (jDBCPoolManager) {
            pool = POOL_CACHE.get(key);
            if (pool != null) {
                return pool;
            }
            pool = this.createDataSource(type, url, user, password, parameter);
            POOL_CACHE.put(key, pool);
            return pool;
        }
    }

    public synchronized void remove(Constants.DATA_SOURCE_TYPE type, String url, String user, String password) {
        String key = this.getPoolAliasName(type, url, user, password, null);
        DataSource pool = POOL_CACHE.get(key);
        if (pool != null) {
            this.destoryPool(pool);
            POOL_CACHE.remove(key);
        }
    }

    private void destoryPool(DataSource pool) {
        try {
            Function.invokeMethod((Object)pool, (String)"close", (Object[])new Object[0]);
        }
        catch (CommonException e) {
            e.printStackTrace();
        }
    }

    private synchronized DataSource createDataSource(Constants.DATA_SOURCE_TYPE type, String url, String user, String password, DBPoolParameter parameter) {
        Map dataSourceConfig = Bean.getObjectValue((Object)parameter);
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)type);
        url = dialect.createConnectUrl(url);
        String driver = dialect.getJDBCDriver();
        dataSourceConfig.put("driverClassName", driver);
        dataSourceConfig.put("url", url);
        dataSourceConfig.put("username", user);
        dataSourceConfig.put("password", password);
        String className = this.findPoolClass();
        this.log.info(Log4jUtil.MARKER_DIAG, "\u521b\u5efa{}\u8fde\u63a5\u6c60\uff0c\u6570\u636e\u5e93\u7c7b\u578b\uff1a{}\uff0c\u6700\u5927\u8fde\u63a5\u6570\uff1a{}", new Object[]{className, type.name(), parameter.getMaxActive()});
        return this.initDataSource(className, dataSourceConfig);
    }

    private String findPoolClass() {
        String className = null;
        try {
            className = JDBCPoolEnum.valueOf("druid").getClassName();
            return className;
        }
        catch (Exception e) {
            this.log.info("druid\u8fde\u63a5\u6c60\u672a\u627e\u5230");
            try {
                className = JDBCPoolEnum.valueOf("proxool").getClassName();
                return className;
            }
            catch (Exception e2) {
                this.log.info("proxool\u8fde\u63a5\u6c60\u672a\u627e\u5230");
                try {
                    className = JDBCPoolEnum.valueOf("c3p0").getClassName();
                    return className;
                }
                catch (Exception e3) {
                    this.log.info("c3p0\u8fde\u63a5\u6c60\u672a\u627e\u5230");
                    this.log.info("\u6ca1\u6709\u627e\u5230\u4efb\u4f55jdbc\u8fde\u63a5\u6c60\uff0c\u9700\u8981\u5bfc\u5165druid\uff0cproxool\uff0cc3p0\u4efb\u610f\u4e00\u79cdjar\u5305");
                    return className;
                }
            }
        }
    }

    public void inValid(Constants.DATA_SOURCE_TYPE type, String url, String user, String password) throws Exception {
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)type);
        String fullClassName = dialect.getJDBCDriver();
        try (Connection c = null;){
            Class.forName(fullClassName);
            url = dialect.createConnectUrl(url);
            DriverManager.setLoginTimeout(TEST_CONNECT_TIMEOUT);
            c = DriverManager.getConnection(url, user, password);
        }
    }

    private DataSource initDataSource(String fullClassName, Map<String, Object> dataSourceConfig) {
        try {
            Class<?> poolCls = Class.forName(fullClassName);
            DataSource pool = (DataSource)poolCls.newInstance();
            this.setPoolProperties(pool, dataSourceConfig);
            GlobalMetrics.Current.getnDruidPoolCreated().incrementAndGet();
            return pool;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void setPoolProperties(Object pool, Map<String, Object> jdbcCfg) {
        Bean.setObjectValueByFieldName((Object)pool, jdbcCfg);
    }

    private String getPoolAliasName(Constants.DATA_SOURCE_TYPE type, String url, String user, String password, DBPoolParameter parameter) {
        if (parameter == null) {
            parameter = DBPoolParameter.DEFAULT;
        }
        String alias = url.replace("\\", "").replace("/", "").replace("_", "");
        StringBuilder beanName = new StringBuilder();
        beanName.append(type).append("||");
        if (alias != null && !alias.isEmpty()) {
            beanName.append(alias).append("||");
        }
        beanName.append(user).append("||").append(MD5.getMD5String((String)password));
        beanName.append("||").append(parameter.getName());
        beanName.append("_pool");
        return beanName.toString();
    }

    public static HashMap<String, DBPoolParameter> getPoolParameterMap() {
        return POOL_PARAMETER_MAP;
    }

    public static void setPoolParameterMap(HashMap<String, DBPoolParameter> poolParameterMap) {
        POOL_PARAMETER_MAP = poolParameterMap;
    }

    public static Map<String, Object> getDruidpoolMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        metrics.put("poolCount", POOL_CACHE.size());
        POOL_CACHE.forEach((url, ds) -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (ds instanceof DruidDataSource) {
                DruidDataSource dds = (DruidDataSource)ds;
                map.put("poolCount", dds.getPoolingCount());
                map.put("activeCount", dds.getActiveCount());
                map.put("createCount", dds.getCreateCount());
                map.put("closeCount", dds.getCloseCount());
                map.put("minIdle", dds.getMinIdle());
                map.put("maxActive", dds.getMaxActive());
                map.put("ErrorCount", dds.getErrorCount());
                map.put("runningSql", dds.getDataSourceStat().getRuningSqlList());
                map.put("connectionHoldHistogram", dds.getDataSourceStat().getConnectionHoldHistogram());
            }
            metrics.put((String)url, map);
        });
        return metrics;
    }

    static {
        POOL_PARAMETER_MAP.put("default_pool", DBPoolParameter.DEFAULT);
    }
}

