/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.oracle;

import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ADialect;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.db.oracle.OracleResourcesDataInput;
import com.northpool.resources.dialect.db.oracle.OracleResourcesDataOutput;
import com.northpool.resources.dialect.function.Function;
import com.northpool.resources.dialect.function.sql.StandardSQLFunction;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeSDOGeometry;
import com.northpool.type.Types;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.List;

@ADialect(name="oracle", type=Constants.DATA_SOURCE_TYPE.oracle)
public class OracleSQLDialect
extends AbstractSQLDialect
implements ISQLDialect {
    public static OracleSQLDialect INSTANCE = new OracleSQLDialect();
    public static final OracleResourcesDataInput resourcesDataInput = new OracleResourcesDataInput();
    public static final OracleResourcesDataOutput resourcesDataOutput = new OracleResourcesDataOutput();
    public static final int INTERSECTS = 0;
    public static final int CONTAINS = 1;
    public static final int CROSSES = 2;
    public static final int DISJOINT = 3;
    public static final int EQUALS = 4;
    public static final int OVERLAPS = 5;
    public static final int TOUCHES = 6;
    public static final int WITHIN = 7;
    public static final int FILTER = 8;
    public static final String PAGE_ROW_NUM_MARK = "rownum__";

    public boolean isSystemMarkFiled(String filedName) {
        return PAGE_ROW_NUM_MARK.equalsIgnoreCase(filedName);
    }

    public OracleSQLDialect() {
        this.name = Constants.DATA_SOURCE_TYPE.oracle.name();
        this.registerTypesAndFunctions();
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.oracle;
    }

    public String getLimitString(String sql, boolean hasOffset, List<Object> parameterList, List<Type> inputTypes, int firstResult, int maxResults) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase().endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        if (hasOffset) {
            String limitSql = sql.replace("select", "select rownum rownum__,");
            limitSql = sql.indexOf("where") != -1 ? limitSql + " and rownum <= ? " : limitSql + " where rownum <= ? ";
            pagingSelect.append(limitSql);
        } else {
            pagingSelect.append(sql);
        }
        if (hasOffset) {
            pagingSelect.append(" ) where rownum__ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        parameterList.add(maxResults);
        inputTypes.add((Type)TypeInteger.INSTANCE);
        return pagingSelect.toString();
    }

    public String getSelfDesc() {
        return "Oracle\u65b9\u8a00";
    }

    public String getJDBCDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    public String createConnectUrl(String url) {
        return "jdbc:oracle:thin:@" + url;
    }

    protected void registerTypes() {
        this.registerType((Type)Types.BIGDECIMAL, new String[]{"NUMBER", "DECIMAL"});
        this.registerClassType((Type)Types.BIGDECIMAL, new Class[]{BigDecimal.class});
        this.registerClassType((Type)Types.INTEGER, new Class[]{Integer.class});
        this.registerType((Type)Types.LONG, new String[]{"LONG"});
        this.registerClassType((Type)Types.LONG, new Class[]{Long.class});
        this.registerType((Type)Types.DOUBLE, new String[]{"FLOAT", "DOUBLE", "DOUBLE PRECISION"});
        this.registerClassType((Type)Types.DOUBLE, new Class[]{Double.class, Float.class});
        this.registerType(TypeSDOGeometry.INSTANCE, new String[]{"SDO_GEOMETRY"});
        this.registerClassType(TypeSDOGeometry.INSTANCE, new Class[]{Geom.class});
        this.registerType((Type)Types.STRING, new String[]{"VARCHAR2", "CHAR", "NCHAR", "NVARCHAR2"});
        this.registerClassType((Type)Types.STRING, new Class[]{String.class});
        this.registerType((Type)Types.TIME_STAMP, new String[]{"DATE", "TIMESTAMP"});
        this.registerClassType((Type)Types.TIME_STAMP, new Class[]{Date.class});
        this.registerType((Type)Types.BOOLEAN, new String[]{"boolean"});
        this.registerClassType((Type)Types.BOOLEAN, new Class[]{Boolean.class});
        this.registerType((Type)Types.BYTES, new String[]{"BLOB"});
        this.registerClassType((Type)Types.BYTES, new Class[]{Blob.class});
        this.registerType((Type)Types.BYTES, new String[]{"CLOB"});
        this.registerClassType((Type)Types.BYTES, new Class[]{Clob.class});
    }

    protected void registerTypesAndFunctions() {
        this.registerTypes();
        this.registerFunctions();
    }

    protected void registerFunctions() {
        Type[] typeIn = new Type[]{TypeSDOGeometry.INSTANCE, TypeSDOGeometry.INSTANCE};
        this.registerFunction("intersects", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 0));
        this.registerFunction("equals", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 4));
        this.registerFunction("contains", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 1));
        this.registerFunction("crosses", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 2));
        this.registerFunction("disjoint", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 3));
        this.registerFunction("touches", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 6));
        this.registerFunction("within", (Function)new SpatialRelateFunction("SDO_RELATE", (Type)Types.VOID, typeIn, 7));
        this.registerFunction("mbr_intersects", (Function)new SpatialRelateFunction("SDO_FILTER", (Type)Types.VOID, typeIn, 8));
    }

    public Boolean markForTableNameAndColumnName() {
        return true;
    }

    public String getDefaultSchema() {
        return null;
    }

    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        return false;
    }

    public Boolean isFieldSerial(String columnTypeName) {
        return null;
    }

    public String createSequenceName(String schema, String tableName, String fieldName) {
        return null;
    }

    public String hasSequenceSql(String sequenceName) {
        return null;
    }

    public String getCreateSequenceSQL(String sequenceName) {
        return null;
    }

    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        return false;
    }

    public ICreateTableFieldRefDialect<List<String>, String> getCreateTableFieldRefDialect() {
        return null;
    }

    public IResourcesDataInput<PreparedStatement, Integer> getResourcesDataDataInput() {
        return resourcesDataInput;
    }

    public IResourcesDataOutput<ResultSet, Integer> getResourcesDataOutput() {
        return resourcesDataOutput;
    }

    public class SpatialRelateFunction
    extends StandardSQLFunction {
        private int spatialRelation;

        public SpatialRelateFunction(String name, Type returnType, Type[] argumentsType, int spatialRelation) {
            super(name, argumentsType, returnType);
            this.spatialRelation = spatialRelation;
        }

        public String render(List<?> arguments) {
            String mask = "";
            switch (this.spatialRelation) {
                case 0: {
                    mask = "ANYINTERACT";
                    break;
                }
                case 1: {
                    mask = "CONTAINS+COVERS";
                    break;
                }
                case 2: {
                    throw new UnsupportedOperationException("Oracle Spatial does't have equivalent CROSSES relationship");
                }
                case 3: {
                    mask = "ANYINTERACT";
                    break;
                }
                case 4: {
                    mask = "EQUAL";
                    break;
                }
                case 5: {
                    mask = "OVERLAPBDYDISJOINT+OVERLAPBDYINTERSECT";
                    break;
                }
                case 6: {
                    mask = "TOUCH";
                    break;
                }
                case 7: {
                    mask = "INSIDE+COVEREDBY";
                    break;
                }
                case 8: {
                    return this.getSpatialFilterExpression(arguments);
                }
                default: {
                    throw new IllegalArgumentException("undefined SpatialRelation passed (" + this.spatialRelation + ")");
                }
            }
            StringBuffer buffer = new StringBuffer("SDO_RELATE(");
            for (int i = 0; i < arguments.size(); ++i) {
                buffer.append(arguments.get(i));
                if (i >= arguments.size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append(",'mask=" + mask + "') = 'TRUE'");
            return buffer.toString();
        }

        public String getSpatialFilterExpression(List<?> arguments) {
            StringBuffer buffer = new StringBuffer("SDO_FILTER(");
            for (int i = 0; i < arguments.size(); ++i) {
                buffer.append(arguments.get(i));
                if (i >= arguments.size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append(") = 'TRUE'");
            return buffer.toString();
        }

        public Boolean isSpatial() {
            return true;
        }
    }
}

