/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.postgresql;

import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.db.AbstractResourcesDataOutput;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Geom;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresSQLResourcesDataOutput
extends AbstractResourcesDataOutput
implements IResourcesDataOutput<ResultSet, Integer> {
    private static Logger logger = LoggerFactory.getLogger(PostgresSQLResourcesDataOutput.class);

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.postgreSQL;
    }

    @Override
    public Geom columnGeometry(ResultSet output, Integer indexOrLabelName) throws Exception {
        try {
            String hex = output.getString(indexOrLabelName);
            if (hex == null) {
                return null;
            }
            Geom m = new Geom(Constants.SPATIAL_TYPE.hexwkb, (Object)hex);
            return m;
        }
        catch (Exception ex) {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.error("\u89e3\u6790\u7a7a\u95f4\u56fe\u5f62\u5b57\u6bb5\u51fa\u9519\uff1a" + ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
    }
}

