/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.postgresql;

import com.northpool.commons.bits.HexUtils;
import com.northpool.spatial.AGeomEncoder;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomEncoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.AbstractWkbEncoder;
import java.nio.ByteOrder;

@AGeomEncoder(type=Constants.SPATIAL_TYPE.hexwkb)
public class HexWkbEncoder
extends AbstractWkbEncoder
implements GeomEncoder<String> {
    public static final HexWkbEncoder ENCODER = new HexWkbEncoder();

    public String fromGeoBuffer(GeoBuffer geoBuffer) {
        return this.fromGeoBuffer(geoBuffer, true, ByteOrder.LITTLE_ENDIAN);
    }

    public String fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        Integer srid = geoBuffer.getSRID();
        if (srid == null) {
            srid = 0;
        }
        geoBuffer.setSRID(srid);
        byte[] wkb = super._fromGeoBuffer(geoBuffer, byteOrder, includeSrid);
        return HexUtils.bytesToHexString((byte[])wkb);
    }
}

