/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.postgresql;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.resources.dialect.db.AbstractResourcesDataInput;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;
import com.northpool.type.TypePostGisGeometry;
import com.northpool.type.TypeString;
import java.sql.PreparedStatement;
import org.postgresql.util.PGobject;

public class PostgresSQLResourcesDataInput
extends AbstractResourcesDataInput
implements IResourcesDataInput<PreparedStatement, Integer> {
    static final String POSTGIS_GEOMETRY_NAME = "geometry";

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.postgreSQL;
    }

    @Override
    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 2000);
            return;
        }
        if (!(value instanceof Geom)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypePostGisGeometry.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Geom geom = (Geom)value;
        TypePostGisGeometry.INSTANCE.isType(geom);
        PGobject po = new PGobject();
        po.setType(POSTGIS_GEOMETRY_NAME);
        po.setValue((String)geom.getOriginGeom());
        input.setObject(indexOrLabelName, po);
    }

    @Override
    public void columnString(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        String strValue;
        if (value == null) {
            input.setNull(indexOrLabelName, 12);
            return;
        }
        if (TypeString.INSTANCE.isType(value)) {
            strValue = (String)value;
            if (strValue.indexOf("''") != -1) {
                strValue = strValue.replaceAll("''", "'");
            }
        } else {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeString.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setString(indexOrLabelName, strValue);
    }
}

