/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.db;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import java.util.HashMap;
import java.util.Map;

public class DataSourceTemplate {
    protected String poolType;
    protected Map<String, String> propertys;

    public void setPoolType(String poolType) {
        this.poolType = poolType;
    }

    public void setPropertys(Map<String, String> propertys) {
        this.propertys = propertys;
    }

    public Map<String, String> getDataSourceConfig(String url, Constants.DATA_SOURCE_TYPE type, String username, String password, Map<String, String> other) {
        if ("DRUID".equalsIgnoreCase(this.poolType)) {
            return this.doDRUID(url, type, username, password, other);
        }
        return null;
    }

    private Map<String, String> doDRUID(String url, Constants.DATA_SOURCE_TYPE type, String username, String password, Map<String, String> other) {
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)type);
        url = dialect.createConnectUrl(url);
        String driver = dialect.getJDBCDriver();
        HashMap<String, String> m = new HashMap<String, String>();
        m.putAll(this.propertys);
        if (other != null) {
            m.putAll(other);
        }
        m.put("driverClassName", driver);
        m.put("url", url);
        m.put("username", username);
        m.put("password", password);
        return m;
    }
}

