/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.db.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.db.DBTable;
import com.northpool.resources.datatable.db.operate.IDBTableOperator;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.jdbc.IJDBCGenericDao;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.resources.sql.jdbc.JDBCGenericDaoImpl;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBTableOperator
extends AbstractTableOperator
implements IDBTableOperator {
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_SIZE = "COLUMN_SIZE";
    public static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String NULLABLE = "NULLABLE";
    public static final String COLUMN_DEF = "COLUMN_DEF";
    public static final String KEY_SEQ = "KEY_SEQ";
    public static final String REMARKS = "REMARKS";
    public static final String VIEW_PK_COLUMN_NAME = "vid";
    protected Logger logger = LoggerFactory.getLogger(AbstractDBTableOperator.class);
    protected Boolean isCaseSensitive;
    protected Connection dbconn;
    protected String cataLog;
    protected Boolean isView = false;
    protected Boolean hasSequence;
    protected IJDBCGenericDao genericDao;
    protected String tableRemarks;
    protected ISQLDialect dialect;

    protected Connection getConnection() {
        return this.dbconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;
        this.isCaseSensitive = config != null ? Boolean.valueOf(config.get("isCaseSensitive") == null ? true : (Boolean)config.get("isCaseSensitive")) : Boolean.valueOf(true);
        this.dataSource = dataSource;
        DbDataSource dbDataSource = (DbDataSource)this.dataSource;
        this.tryConnection(dbDataSource);
        this.dbconn = dbDataSource.connection().getConnection();
        try {
            this.processTableNameAndSchema(tableName, this.schema, this.isCaseSensitive);
            this.dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)dbDataSource.getDataSourceType());
            this.genericDao = new JDBCGenericDaoImpl(dbDataSource);
            this.dbconn = this.getConnection();
            this.cataLog = this.getCataLog();
            DatabaseMetaData dbmd = this.dbconn.getMetaData();
            this.buildTableInfo(dbmd, this.tableName, this.schema);
            if (this.hasSpatialColumn().booleanValue()) {
                this.buildSpatialColumnInfo();
            }
        }
        finally {
            this.dbconn.close();
        }
    }

    protected void tryConnection(DbDataSource dbDataSource) throws Exception {
        try {
            dbDataSource.testConnection();
        }
        catch (Exception e) {
            throw new Exception(dbDataSource.toString() + " \u6d4b\u8bd5\u8fde\u63a5\u8d85\u65f6,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u4fe1\u606f\u662f\u5426\u6b63\u786e:" + e.getMessage());
        }
    }

    protected String getCataLog() throws SQLException {
        ResultSet resultSet = this.dbconn.getMetaData().getCatalogs();
        if (resultSet.wasNull()) {
            throw new RuntimeException(this.tableName + "\u83b7\u53d6\u4fe1\u606f\u51fa\u73b0\u95ee\u9898,\u83b7\u5f97\u4e0d\u5230CataLog\u4fe1\u606f");
        }
        resultSet.next();
        String catalog = resultSet.getString("TABLE_CAT");
        resultSet.close();
        return catalog;
    }

    protected abstract void processTableNameAndSchema(String var1, String var2, Boolean var3);

    protected abstract String getRemarks(ResultSet var1) throws SQLException;

    protected abstract ResultSet getColumns(DatabaseMetaData var1, String var2, String var3) throws SQLException;

    protected abstract IColumn createColumn(String var1, Integer var2, Integer var3, String var4, Boolean var5, String var6, String var7);

    protected abstract CompletableFuture<Object> createSpatialIndex(String var1);

    public String mark() {
        return this.cataLog + '_' + this.schema + '.' + this.tableName + "@" + this.dataSource.mark();
    }

    public String toString() {
        return this.cataLog + '_' + this.schema + '.' + this.tableName + "@" + this.dataSource.toString();
    }

    public CompletableFuture<Object> dropIndex(String indexName) {
        if (this.isView.booleanValue()) {
            throw new RuntimeException(this.mark() + "\u4e3a\u89c6\u56fe,\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + ";\u5220\u9664\u7d22\u5f15" + indexName);
            String indexName1 = indexName;
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                indexName1 = "\"" + indexName1 + "\"";
            }
            String sql = "drop index " + indexName1;
            this.genericDao.doExecuteSql(sql, null, null);
            this.dropIndexInIndexMap(indexName);
            return null;
        });
        return promise;
    }

    public CompletableFuture<Object> dropPK() {
        if (this.isView.booleanValue()) {
            throw new RuntimeException(this.mark() + "\u4e3a\u89c6\u56fe,\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.getPk() == null) {
            CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
                this.logger.info(this.mark() + ";\u6ca1\u6709\u4e3b\u952e\u7d22\u5f15");
                return null;
            });
            return promise;
        }
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + ";\u5220\u9664\u7d22\u5f15" + this.getPk().getName());
            String tableName = this.tableName;
            String pkName = this.getPk().getName();
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                tableName = "\"" + tableName + "\"";
                pkName = "\"" + pkName + "\"";
            }
            String sql = "ALTER TABLE " + tableName + " DROP CONSTRAINT " + pkName;
            this.genericDao.doExecuteSql(sql, null, null);
            this.dropIndexInIndexMap(this.getPk().getName());
            return null;
        });
        return promise;
    }

    public CompletableFuture<Object> createPK(String colname) {
        if (this.isView.booleanValue()) {
            throw new RuntimeException(this.mark() + "\u4e3a\u89c6\u56fe,\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        if (this.getPk() != null) {
            throw new RuntimeException(this.mark() + "\u5df2\u6709\u4e3b\u952e\u5b57\u6bb5:" + this.getPk().getColname());
        }
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + "_" + colname + "\u521b\u5efa\u4e3b\u952e");
            String pkName = this.createPKName();
            String colname1 = colname;
            String tableName = this.tableName;
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                tableName = "\"" + tableName + "\"";
                pkName = "\"" + pkName + "\"";
                colname1 = "\"" + colname1 + "\"";
            }
            String sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT " + pkName + " PRIMARY KEY(" + colname1 + ")";
            this.genericDao.doExecuteSql(sql, null, null);
            Index index = new Index();
            index.setName(pkName);
            index.setUnique(Boolean.valueOf(true));
            index.addColname(colname);
            index.setIsPK(Boolean.valueOf(true));
            this.addToIndexMap(colname, (IIndex)index);
            return null;
        });
        return promise;
    }

    public CompletableFuture<Object> _createIndex(Boolean unique, String ... colnames) {
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + "_" + String.join((CharSequence)",", colnames) + "\u521b\u5efa\u7d22\u5f15");
            String indexName = this.createIndexName(colnames);
            String tableName = this.tableName;
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                tableName = "\"" + tableName + "\"";
                indexName = "\"" + indexName + "\"";
                for (int i = 0; i < colnames.length; ++i) {
                    colnames[i] = "\"" + colnames[i] + "\"";
                }
            }
            String sql = "CREATE " + (unique == true ? "UNIQUE" : "") + " INDEX " + indexName + " ON " + tableName + " (" + String.join((CharSequence)",", colnames) + ");";
            this.logger.info("execute sql" + sql);
            this.genericDao.doExecuteSql(sql, null, null);
            Index index = new Index();
            index.setName(indexName);
            index.setUnique(unique);
            for (String colname : colnames) {
                index.addColname(colname);
                this.addToIndexMap(colname, (IIndex)index);
            }
            return null;
        });
        return promise;
    }

    protected void buildIndexInfo(DatabaseMetaData dbmd) throws SQLException {
        this.indexMap = this.getIndexInfo(dbmd);
    }

    protected LinkedHashMap<String, IIndex> getIndexInfo(DatabaseMetaData dbmd) throws SQLException {
        LinkedHashMap<String, IIndex> map = new LinkedHashMap<String, IIndex>();
        if (!this.isView.booleanValue()) {
            ResultSet indexes = dbmd.getIndexInfo(this.cataLog, this.schema, this.tableName, false, false);
            while (indexes.next()) {
                String indname = indexes.getString("INDEX_NAME");
                String asc = indexes.getString("ASC_OR_DESC");
                boolean nonunique = indexes.getBoolean("NON_UNIQUE");
                String colname = indexes.getString(COLUMN_NAME);
                Index index = new Index();
                index.setAsc(asc);
                index.setName(indname);
                index.setUnique(Boolean.valueOf(!nonunique));
                index.addColname(colname);
                IColumn column = (IColumn)this.columnMap.get(colname);
                if (column != null && column.isSpatial().booleanValue()) {
                    index.setSpatial(Boolean.valueOf(true));
                }
                map.put(indname, (IIndex)index);
            }
            indexes.close();
        }
        return map;
    }

    public IIndex getPrimaryInfo(DatabaseMetaData dbmd) throws SQLException {
        Index pk = null;
        if (this.isView.booleanValue()) {
            for (Map.Entry set : this.columnMap.entrySet()) {
                IColumn column = (IColumn)set.getValue();
                String columnName = column.getColumnName();
                if (!VIEW_PK_COLUMN_NAME.equalsIgnoreCase(columnName)) continue;
                pk = new Index();
                pk.setName(this.createPKName());
                pk.setUnique(Boolean.valueOf(true));
                pk.setIsPK(Boolean.valueOf(true));
                pk.setColname(columnName);
            }
        } else {
            ResultSet pkeys = dbmd.getPrimaryKeys(this.cataLog, this.schema, this.tableName.replace("\"", ""));
            String pkName = null;
            if (pkeys.next()) {
                String pkeystr = pkeys.getString(COLUMN_NAME);
                IColumn colunm = (IColumn)this.columnMap.get(pkeystr);
                pkName = pkeys.getString("PK_NAME");
                if (colunm != null) {
                    pk = new Index();
                    pk.setName(pkName);
                    pk.setUnique(Boolean.valueOf(true));
                    pk.setIsPK(Boolean.valueOf(true));
                    pk.setColname(colunm.getColumnName());
                }
            }
            if (pkeys.next()) {
                throw new RuntimeException("\u8868/\u89c6\u56fe" + this.mark() + "\u4e3a\u8054\u5408\u4e3b\u952e,\u7cfb\u7edf\u4e0d\u652f\u6301\u8054\u5408\u4e3b\u952e");
            }
            pkeys.close();
        }
        return pk;
    }

    protected void buildPrimaryInfo(DatabaseMetaData dbmd) throws SQLException {
        IIndex pk = this.getPrimaryInfo(dbmd);
        if (pk != null) {
            this.addToIndexMap(pk.getName(), pk);
            if (pk.isComposite().booleanValue()) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u6df7\u5408\u4e3b\u952e");
            }
            ((IColumn)this.columnMap.get(pk.getColname())).setPK();
        }
    }

    protected void buildTableInfo(DatabaseMetaData dbmd, String tableName, String schema) throws Exception {
        this.getTableInfo(dbmd, tableName);
        this.buildColumns(dbmd, tableName, schema);
        this.buildIndexInfo(dbmd);
        this.buildPrimaryInfo(dbmd);
    }

    protected void getTableInfo(DatabaseMetaData dbmd, String tableName) throws SQLException {
        ResultSet resultSet = dbmd.getTables(this.cataLog, this.schema, this.tableName, new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW"});
        if (resultSet.wasNull()) {
            throw new RuntimeException("\u8868/\u89c6\u56fe" + this.mark() + "\u4e0d\u5b58\u5728");
        }
        if (resultSet.next()) {
            String type = resultSet.getString("TABLE_TYPE");
            this.tableRemarks = resultSet.getString(REMARKS);
            resultSet.close();
            if (!"TABLE".equalsIgnoreCase(type)) {
                this.isView = true;
            }
        } else {
            throw new RuntimeException("\u8868/\u89c6\u56fe" + this.mark() + "\u4e0d\u5b58\u5728");
        }
    }

    protected void buildColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
        this.columnMap = this.getBuildColumns(dbmd, tableName, schema);
    }

    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException {
        String schema = this.schema;
        String tableName = this.tableName;
        String colunmName1 = colunmName;
        if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
            colunmName1 = "\"" + colunmName1 + "\"";
            schema = "\"" + schema + "\"";
            tableName = "\"" + tableName + "\"";
        }
        String sql = "select " + colunmName1 + " from " + this.dialect.processTableNameAndSchema(schema, tableName);
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        Type type = ((IColumn)this.columnMap.get(colunmName)).getType();
        typeMap.put(colunmName, type);
        List<Map<String, Object>> i = this.genericDao.queryBySql(sql, null, null, null, 0, 1, null, IJDBCTransformer.MAP);
        if (i.isEmpty()) {
            return null;
        }
        Map<String, Object> data = i.get(0);
        Object o = data.get(colunmName);
        if (o == null) {
            return null;
        }
        Geom geo = (Geom)data.get(colunmName);
        return geo.toGeoBuffer();
    }

    protected AbstractTable _getTable() {
        return new DBTable();
    }

    public void close() throws Exception {
    }

    public LinkedHashMap<String, IColumn> getTableColumns() throws Exception {
        DatabaseMetaData dbmd = ((DbDataSource)this.dataSource).connection().getConnection().getMetaData();
        return this.getBuildColumns(dbmd, this.tableName, this.schema);
    }

    protected LinkedHashMap<String, IColumn> getBuildColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
        try (ResultSet columns = this.getColumns(dbmd, tableName, schema);){
            LinkedHashMap<String, IColumn> buildColumnMap = new LinkedHashMap<String, IColumn>();
            while (columns.next()) {
                String columName = columns.getString(COLUMN_NAME);
                Integer columSize = columns.getInt(COLUMN_SIZE);
                String columTypeName = columns.getString(TYPE_NAME);
                Integer digits = 0;
                short columType = columns.getShort(DATA_TYPE);
                if (columType == 3 || columType == 2) {
                    digits = columns.getInt(DECIMAL_DIGITS);
                }
                boolean nullable = columns.getInt(NULLABLE) == 1;
                String defaultValue = columns.getString(COLUMN_DEF);
                String colRemarks = this.getRemarks(columns);
                IColumn column = this.createColumn(columName, columSize, digits, columTypeName, nullable, defaultValue, colRemarks);
                buildColumnMap.put(column.getColumnName(), column);
            }
            LinkedHashMap<String, IColumn> linkedHashMap = buildColumnMap;
            return linkedHashMap;
        }
    }
}

