/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db;

import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.type.Type;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypeDouble;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeLong;
import com.northpool.type.TypeString;
import com.northpool.type.TypeTimestamp;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;

public abstract class AbstractResourcesDataInput
implements IResourcesDataInput<PreparedStatement, Integer> {
    public void columnBoolean(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 16);
            return;
        }
        if (!TypeBoolean.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeBoolean.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setBoolean(indexOrLabelName, (Boolean)value);
    }

    public void columnBigDecimal(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 2);
            return;
        }
        if (!TypeBigDecimal.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeBigDecimal.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setBigDecimal(indexOrLabelName, (BigDecimal)value);
    }

    public void columnBytes(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 2004);
            return;
        }
        if (!TypeBytes.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeBytes.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setBytes(indexOrLabelName, (byte[])value);
    }

    public void columnDouble(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 8);
            return;
        }
        if (!TypeDouble.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeDouble.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setDouble(indexOrLabelName, (Double)value);
    }

    public abstract void columnGeometry(PreparedStatement var1, Object var2, Integer var3) throws Exception;

    public void columnInteger(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 4);
            return;
        }
        if (!TypeInteger.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeInteger.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setInt(indexOrLabelName, (Integer)value);
    }

    public void columnLong(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, -5);
            return;
        }
        if (!TypeLong.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeLong.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setLong(indexOrLabelName, (Long)value);
    }

    public void columnString(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 12);
            return;
        }
        if (!TypeString.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeString.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setString(indexOrLabelName, (String)value);
    }

    public void columnTimestamp(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 93);
            return;
        }
        if (!TypeTimestamp.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeTimestamp.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Timestamp st = new Timestamp(((Date)value).getTime());
        input.setTimestamp(indexOrLabelName, st);
    }
}

