/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datasource.db.JDBCPoolManager;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.jdbc.CannotGetJdbcConnectionException;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.resources.sql.jdbc.JDBCScrollStatement;
import com.northpool.resources.sql.jdbc.PreparedStatementCallback;
import com.northpool.resources.sql.jdbc.PreparedStatementCreator;
import com.northpool.resources.sql.jdbc.PreparedStatementSetValueException;
import com.northpool.resources.sql.jdbc.Transactions;
import com.northpool.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractsJDBCCell<T> {
    protected ISQLDialect dialect;
    protected IJDBCTransformer<T> transformer;
    protected String sql;
    protected Map<String, Type> returnTypeMap = new HashMap<String, Type>();
    protected List<Type> inputTypes = new ArrayList<Type>();
    protected DbDataSource dbDataSource;
    protected boolean ignoreWarnings = false;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractsJDBCCell.class);
    protected IResourcesDataInput<PreparedStatement, Integer> dataInput;

    public AbstractsJDBCCell(IDataSource dataSource, ISQLDialect dialect, String sql) {
        this.dialect = dialect;
        if (!(dataSource instanceof DbDataSource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u4e0d\u80fd\u652f\u6301JDBC\u64cd\u4f5c,type:" + dataSource.getDataSourceType());
        }
        this.dbDataSource = (DbDataSource)dataSource;
        this.dataInput = dialect.getResourcesDataDataInput();
        this.sql = sql;
    }

    public void setInputTypes(Type[] inputTypes) {
        if (inputTypes != null) {
            this.inputTypes = new ArrayList<Type>(Arrays.asList(inputTypes));
        }
    }

    protected <RETURN> RETURN execute(PreparedStatementCreator psc, PreparedStatementCallback<RETURN> action) throws SQLException {
        Connection con;
        assert (psc != null);
        assert (action != null);
        if (logger.isTraceEnabled()) {
            logger.trace("Executing prepared SQL statement" + (this.sql != null ? " [" + this.sql + "]" : ""));
        }
        try {
            con = AbstractsJDBCCell.getConnection(this.dbDataSource);
        }
        catch (CannotGetJdbcConnectionException e) {
            throw new SQLException(e);
        }
        PreparedStatement ps = null;
        try {
            ps = psc.createPreparedStatement(con);
            RETURN result = action.doInPreparedStatement(ps);
            this.handleWarnings(ps);
            RETURN RETURN = result;
            return RETURN;
        }
        catch (SQLException ex) {
            psc = null;
            AbstractsJDBCCell.closeStatement(ps);
            ps = null;
            AbstractsJDBCCell.releaseConnection(con, this.dbDataSource);
            con = null;
            throw new SQLException(this.sql, ex);
        }
        finally {
            AbstractsJDBCCell.closeStatement(ps);
            AbstractsJDBCCell.releaseConnection(con, this.dbDataSource);
        }
    }

    protected void setValues(PreparedStatement ps, Object[] args, Type[] types) throws PreparedStatementSetValueException {
        int index = 1;
        for (int i = 0; i < args.length; ++i) {
            Type t = types[i];
            try {
                Object valueInput = t.toType(args[i]);
                this.dialect.getResourcesDataDataInput().input((Object)ps, t, valueInput, (Object)index);
            }
            catch (Exception e) {
                throw new PreparedStatementSetValueException(e);
            }
            ++index;
        }
    }

    private static Connection getConnection(DbDataSource dbDataSource) throws CannotGetJdbcConnectionException {
        DataSource dataSource = Transactions.getThreadDataSource(dbDataSource);
        if (dataSource == null) {
            dataSource = JDBCPoolManager.getInstance().getPool(dbDataSource);
        }
        try {
            return dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new CannotGetJdbcConnectionException("Failed to obtain JDBC Connection", ex);
        }
        catch (IllegalStateException ex) {
            throw new CannotGetJdbcConnectionException("Failed to obtain JDBC Connection: " + ex.getMessage());
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.trace("Could not close JDBC Statement", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace("Unexpected exception on closing JDBC Statement", ex);
            }
        }
    }

    public static void releaseConnection(Connection con, DbDataSource dbDataSource) {
        if (con == null) {
            return;
        }
        try {
            DataSource dataSource = Transactions.getThreadDataSource(dbDataSource);
            if (dataSource == null) {
                con.close();
            }
        }
        catch (SQLException ex) {
            logger.debug("Could not close JDBC Connection", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing JDBC Connection", ex);
        }
    }

    protected IScroll<T> executeScroll(PreparedStatementCreator psc, Object[] args, Type[] types) throws SQLException {
        Connection con;
        assert (psc != null);
        try {
            con = AbstractsJDBCCell.getConnection(this.dbDataSource);
        }
        catch (CannotGetJdbcConnectionException e) {
            throw new SQLException(e);
        }
        PreparedStatement ps = null;
        if (logger.isTraceEnabled()) {
            logger.trace("Executing prepared SQL statement" + (this.sql != null ? " [" + this.sql + "]" : ""));
        }
        try {
            ps = psc.createPreparedStatement(con);
            ResultSet rs = null;
            this.setValues(ps, args, types);
            rs = ps.executeQuery();
            IScroll _scroll = this.transformer.extractDataScroll((IDialect)this.dialect, rs, this.returnTypeMap, new JDBCScrollStatement(this.dbDataSource, con, ps));
            this.handleWarnings(ps);
            IScroll iScroll = _scroll;
            return iScroll;
        }
        catch (PreparedStatementSetValueException | SQLException ex) {
            psc = null;
            AbstractsJDBCCell.closeStatement(ps);
            ps = null;
            AbstractsJDBCCell.releaseConnection(con, this.dbDataSource);
            con = null;
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(this.sql, ex);
        }
    }

    protected void handleWarnings(Statement stmt) throws SQLException {
        if (this.ignoreWarnings && logger.isDebugEnabled()) {
            for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                logger.debug("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]");
            }
        }
    }
}

