/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IQuery;
import com.northpool.resources.sql.jdbc.AbstractsJDBCCell;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.type.Type;
import com.northpool.type.TypeInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCQuery<T>
extends AbstractsJDBCCell<T>
implements IQuery<T, IJDBCTransformer<T>> {
    Logger logger = LoggerFactory.getLogger(JDBCQuery.class);
    private boolean showGeoQuerySql = true;
    protected int firstResult = -1;
    protected int maxResults = -1;
    protected List<Object> parameterList = new ArrayList<Object>();
    protected Integer fetchSize;

    public JDBCQuery(IDataSource dataSource, ISQLDialect dialect, String sql) {
        super(dataSource, dialect, sql);
    }

    public JDBCQuery<T> addScalar(Map<String, Type> returnTypeMap) {
        this.returnTypeMap = returnTypeMap;
        return this;
    }

    public JDBCQuery<T> addScalar(String key, Type type) {
        this.returnTypeMap.put(key, type);
        return this;
    }

    public JDBCQuery<T> setParameter(int index, Object arg) {
        this.parameterList.add(index, arg);
        return this;
    }

    public JDBCQuery<T> setParameters(Object[] args) {
        this.parameterList.addAll(Arrays.asList(args));
        return this;
    }

    public JDBCQuery<T> setFirstResult(Integer firstResult) {
        if (firstResult != null) {
            this.firstResult = firstResult;
        }
        return this;
    }

    public JDBCQuery<T> setMaxResults(Integer maxResults) {
        if (maxResults != null) {
            this.maxResults = maxResults;
        }
        return this;
    }

    protected void printSQL() {
        this.logger.debug(this.sql);
        if (Log4jUtil.isDiagnoseEnable() && Log4jUtil.isShowSql() && this.showGeoQuerySql && this.parameterList.size() <= 3 && null != this.sql && this.sql.contains("(\"shape\"")) {
            this.logger.info(Log4jUtil.MARKER_DIAG, "\u7a7a\u95f4\u67e5\u8be2\u8bed\u53e5\uff1a{}, \u53c2\u6570\uff1a{}", (Object)this.sql, (Object)StringUtils.join(this.parameterList, (String)","));
        }
    }

    public List<T> list() throws DataAccessException {
        this.createLimit();
        this.printSQL();
        int fetchsize = this.fetchSize == null ? IDAO.DEFAULT_FETCH_SIZE : this.fetchSize;
        Object[] args = this.parameterList.toArray(new Object[this.parameterList.size()]);
        try {
            List iListReturn = this.execute(con -> this.prepareQueryStatement(con, fetchsize), ps -> {
                List iList = null;
                try (ResultSet rs = null;){
                    this.setValues(ps, args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                    rs = ps.executeQuery();
                    iList = this.transformer.extractData((IDialect)this.dialect, rs, this.returnTypeMap);
                }
                return iList;
            });
            return iListReturn;
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
    }

    protected final PreparedStatement prepareQueryStatement(Connection connection, Integer fetchSize) throws SQLException {
        int queryTimeout;
        PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
        if (fetchSize != null) {
            if (fetchSize <= 0) {
                fetchSize = null;
            } else {
                this.dialect.setFetchSize(connection, preparedStatement, fetchSize);
            }
        }
        if ((queryTimeout = GlobalTileSettings.DB_QUERY_TIMEOUT_SECONDS) > 0) {
            preparedStatement.setQueryTimeout(queryTimeout);
        }
        return preparedStatement;
    }

    protected void createLimit() {
        boolean useLimit = false;
        boolean hasOffset = false;
        if (this.maxResults > 0) {
            if (this.firstResult < 0) {
                this.firstResult = 0;
            } else {
                hasOffset = true;
            }
            useLimit = true;
        } else if (this.firstResult > 0) {
            hasOffset = true;
        }
        if (useLimit) {
            this.sql = this.dialect.getLimitString(this.sql, hasOffset, this.parameterList, this.inputTypes, this.firstResult, this.maxResults);
            if (hasOffset) {
                this.parameterList.add(this.firstResult);
                this.inputTypes.add(TypeInteger.INSTANCE);
            }
        }
    }

    public JDBCQuery<T> setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public IScroll<T> scroll() throws DataAccessException {
        IScroll scroll;
        this.createLimit();
        this.printSQL();
        int fetchsize = this.fetchSize == null ? IDAO.DEFAULT_FETCH_SIZE : this.fetchSize;
        Object[] args = this.parameterList.toArray(new Object[this.parameterList.size()]);
        try {
            scroll = this.executeScroll(con -> this.prepareQueryStatement(con, fetchsize), args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
        return scroll;
    }

    public JDBCQuery<T> setResultTransformer(IJDBCTransformer<T> transformer) {
        this.transformer = transformer;
        return this;
    }
}

