/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.fgdb;

import com.northpool.commons.reflect.Bean;
import com.northpool.exception.UException;
import com.northpool.resources.Constants;
import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.fgdb.FGBDTable;
import com.northpool.resources.datatable.fgdb.FGDBDML;
import com.northpool.resources.datatable.fgdb.FGDBQuery;
import com.northpool.resources.datatable.fgdb.IFGDBTransformer;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.resources.sql.IQuery;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.type.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbstractFGDBDAO<PK, T>
implements IDAO<T, PK> {
    protected IDataSource dataSource;
    protected FGDBDialect dialect;
    protected FGBDTable fgdbTable;
    protected Class<?> clazz;
    protected IFGDBTransformer<T> transformer;

    public AbstractFGDBDAO(IDataSource dataSource, FGBDTable fgdbTable, IFGDBTransformer<T> transformer) {
        this.dataSource = dataSource;
        this.dialect = (FGDBDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)dataSource.getDataSourceType());
        this.fgdbTable = fgdbTable;
        this.transformer = transformer;
    }

    public T get(PK pk) throws DataAccessException {
        return null;
    }

    public Long count(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public List<T> query(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public List<T> query(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.fgdbTable, queryFilter).exceptSpatialFilter();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<T, IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), this.transformer, parameter.getSpatialCommand());
        return query.list();
    }

    public List<Object[]> queryArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.fgdbTable, queryFilter);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<Object[], IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), IFGDBTransformer.ARRAY, parameter.getSpatialCommand());
        return query.list();
    }

    private <ST> IScroll<ST> _scroll(QueryFilter queryFilter, Integer fetchSize, IFGDBTransformer<ST> transformer) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.fgdbTable, queryFilter).exceptSpatialFilter().doNotUseAliasName();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<ST, IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());
        return query.scroll();
    }

    public IScroll<T> scroll(QueryFilter queryFilter) throws DataAccessException {
        return this.scroll(queryFilter, null);
    }

    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IFGDBTransformer.ARRAY);
    }

    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public void insert(T t, boolean insertNull) throws DataAccessException {
        int size = this.fgdbTable.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for (int index = 0; index < size; ++index) {
            IField field = this.fgdbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if (insertNull) {
            args = new Object[size];
            for (int i = 0; i < fieldsInDB.length; ++i) {
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, (String)fieldName);
            }
        } else {
            ArrayList<String> newFieldInDb = new ArrayList<String>(size);
            ArrayList<Object> argsList = new ArrayList<Object>(size);
            ArrayList<Type> typeList = new ArrayList<Type>(size);
            for (int i = 0; i < fieldsInDB.length; ++i) {
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, (String)fieldName);
                if (o == null) continue;
                newFieldInDb.add(fieldInDB);
                argsList.add(o);
                typeList.add(((IField)this.fgdbTable.getFieldsInTableMap().get(fieldInDB)).getType());
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        IDML insert = this.createInsert(this.fgdbTable, fieldsInDB, types);
        insert.insert(args);
    }

    private IDML createInsert(FGBDTable fgdbTable, String[] fieldsInDB, Type[] types) {
        FGDBDML update = new FGDBDML(this.dataSource, this.dialect, fgdbTable.getTablename(), fieldsInDB, FGDBDML.DML_TYPE.insert);
        update.setInputTypes(types);
        return update;
    }

    public void saveOrUpdate(T t) throws DataAccessException {
    }

    public void remove(PK pk) throws DataAccessException {
    }

    public void update(T t) throws DataAccessException {
    }

    public void removeAll() throws DataAccessException {
    }

    public void insertMany(List<T> list) throws DataAccessException {
        this.insertMany(list, IDAO.DEFALT_BATCH_SIZE);
    }

    public void insertMany(final List<T> list, Integer batchSize) throws DataAccessException {
        int size = this.fgdbTable.fields().length;
        ArrayList<String> fieldsInDBArr = new ArrayList<String>();
        ArrayList<String> fieldsArr = new ArrayList<String>();
        ArrayList<Type> typesArr = new ArrayList<Type>();
        for (int index = 0; index < size; ++index) {
            IField field = this.fgdbTable.fields()[index];
            if (field.isPK().booleanValue()) continue;
            fieldsInDBArr.add(field.getOriginFieldName());
            fieldsArr.add(field.getFieldName());
            typesArr.add(field.getType());
        }
        String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        final String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<T> iterator;
            {
                this.iterator = list.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object[] next() {
                Object data = this.iterator.next();
                Object[] values = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object value;
                    String field = fields[i];
                    values[i] = value = Bean.getObjectValueByFieldName(data, (String)field);
                }
                return values;
            }

            public int size() {
                return list.size();
            }
        };
        FGDBDML batchInsert = new FGDBDML(this.dataSource, this.dialect, this.fgdbTable.getTablename(), fieldsInDB, FGDBDML.DML_TYPE.batchInsert);
        batchInsert.setInputTypes(types);
        batchInsert.setBatchSize(batchSize);
        batchInsert.batchInsert(scroll);
    }

    public void insertMany(final List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        String[] fieldsInDB = new String[fields.length];
        final Type[] types = new Type[fields.length];
        Map mapField = this.fgdbTable.getFieldsMap();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            IField dbField = (IField)mapField.get(field);
            if (dbField == null) {
                throw new RuntimeException(String.format("\u8868:%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5", this.fgdbTable.mark(), dbField));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
        }
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<Object[]> iterator;
            {
                this.iterator = list.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object[] next() {
                Object[] data = this.iterator.next();
                for (int i = 0; i < data.length; ++i) {
                    Type type = types[i];
                    data[i] = type.toType(data[i]);
                }
                return data;
            }

            public int size() {
                return list.size();
            }
        };
        FGDBDML batchInsert = new FGDBDML(this.dataSource, this.dialect, this.fgdbTable.getTablename(), fieldsInDB, FGDBDML.DML_TYPE.batchInsert);
        batchInsert.setInputTypes(types);
        batchInsert.setBatchSize(batchSize);
        batchInsert.batchInsert(scroll);
    }

    public void updateMany(T o, QueryFilter queryFilter) throws DataAccessException {
    }

    public void remove(QueryFilter queryFilter) throws DataAccessException {
    }

    public void insert(T t) throws DataAccessException {
    }

    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Type t;
            Object arg = args[i];
            types[i] = t = this.dialect.getTypeByObject(arg);
        }
        return types;
    }

    protected <ST> IQuery<ST, IFGDBTransformer<?>> createQuery(String sql, String[] selectFieldArray, Object[] args, Type[] types, Integer firstResult, Integer maxResults, Map<String, Type> returnType, IFGDBTransformer<ST> transformer, SpatialCommand command) throws DataAccessException {
        FGDBQuery query = new FGDBQuery(this.dataSource, this.dialect, sql, selectFieldArray, this.fgdbTable, command);
        query.setResultTransformer(transformer);
        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes = types == null ? this.guessType(args) : types;
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }
        query.setFirstResult(firstResult).setMaxResults(maxResults);
        return query;
    }

    public IScroll scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IFGDBTransformer.MAP);
    }
}

