/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.fgdb;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.fgdb.FGDBTableBuilder;
import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeometryDef;
import org.fgdbapi.thindriver.xml.SpatialReference;

public class FGDBFieldRefDialect
implements ICreateTableFieldRefDialect<FGDBTableBuilder, Field> {
    public static final FGDBFieldRefDialect INSTANCE = new FGDBFieldRefDialect();

    Field createField(ColumnBean columnBean) {
        Field field = new Field();
        field.setName(columnBean.getColumnName());
        field.setModelName(columnBean.getRemarks() == null ? "" : columnBean.getRemarks());
        if (columnBean.getNullable().booleanValue()) {
            field.setIsNullable(true);
        } else {
            field.setIsNullable(false);
        }
        if (columnBean.getIsSpatial().booleanValue()) {
            field.setRequired(Boolean.valueOf(true));
            field.setIsNullable(false);
        }
        field.setEditable(Boolean.valueOf(true));
        return field;
    }

    public Field columnBoolean(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_SMALL_INTEGER);
        builder.addField(field);
        return field;
    }

    public Field columnBigDecimal(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
        field.setLength(8);
        builder.addField(field);
        return field;
    }

    public Field columnBytes(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_BLOB);
        builder.addField(field);
        return field;
    }

    public Field columnDouble(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
        field.setLength(8);
        builder.addField(field);
        return field;
    }

    public Field columnGeometry(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        EsriGeometryType geomType = EsriTypeUtils.geomType2EsriGeometryType(columnBean.getGeoType());
        SpatialReference gcs = EsriTypeUtils.getSpatialReferenceBySRID(columnBean.getSrid());
        GeometryDef geom = new GeometryDef();
        geom.setGeometryType(geomType);
        geom.setSpatialReference(gcs);
        geom.setGridSize0(Double.valueOf(0.0));
        geom.setHasM(false);
        geom.setHasZ(false);
        field.setGeometryDef(geom);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_GEOMETRY);
        builder.addField(field);
        return field;
    }

    public Field columnInteger(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
        field.setLength(4);
        builder.addField(field);
        return field;
    }

    public Field columnLong(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
        field.setLength(8);
        builder.addField(field);
        return field;
    }

    public Field columnString(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_STRING);
        if (columnBean.getColumnSize() != null) {
            field.setLength(columnBean.getColumnSize().intValue());
        }
        builder.addField(field);
        return field;
    }

    public Field columnTimestamp(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DATE);
        builder.addField(field);
        return field;
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.fgdb;
    }
}

