/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.fgdb;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeTimestamp;
import java.math.BigDecimal;
import java.util.Date;
import org.gdal.ogr.Feature;

public class FGDBResourcesDataOutput
implements IResourcesDataOutput<Feature, Integer> {
    public static final FGDBResourcesDataOutput INSTANCE = new FGDBResourcesDataOutput();

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public Boolean columnBoolean(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        int value = output.GetFieldAsInteger(indexOrLabelName.intValue());
        return (boolean)((Boolean)TypeBoolean.INSTANCE.toType((Object)value));
    }

    public BigDecimal columnBigDecimal(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        double value = output.GetFieldAsDouble(indexOrLabelName.intValue());
        return new BigDecimal(value);
    }

    public byte[] columnBytes(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        byte[] bytes = output.GetFieldAsBinary(indexOrLabelName.intValue());
        return bytes;
    }

    public Double columnDouble(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        double value = output.GetFieldAsDouble(indexOrLabelName.intValue());
        return value;
    }

    public Geom columnGeometry(Feature output, Integer indexOrLabelName) throws Exception {
        byte[] wkb = output.GetGeometryRef().ExportToWkb();
        GeoBuffer GeoBuffer2 = WkbDecoder.DECODER.toGeoBuffer(wkb);
        return new Geom(Constants.SPATIAL_TYPE.wkb, (Object)wkb);
    }

    public Integer columnInteger(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        return output.GetFieldAsInteger(indexOrLabelName.intValue());
    }

    public Long columnLong(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        return output.GetFieldAsInteger64(indexOrLabelName.intValue());
    }

    public String columnString(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        return output.GetFieldAsString(indexOrLabelName.intValue());
    }

    public Date columnTimestamp(Feature output, Integer indexOrLabelName) throws Exception {
        if (output.IsFieldNull(indexOrLabelName.intValue())) {
            return null;
        }
        int[] pnYear = new int[1];
        int[] pnMonth = new int[1];
        int[] pnDay = new int[1];
        int[] pnHour = new int[1];
        int[] pnMinute = new int[1];
        float[] pfSecond = new float[1];
        int[] pnTZFlag = new int[1];
        output.GetFieldAsDateTime(indexOrLabelName.intValue(), pnYear, pnMonth, pnDay, pnHour, pnMinute, pfSecond, pnTZFlag);
        String dateStr = pnYear[0] + "-" + pnMonth[0] + "-" + pnDay[0] + " " + pnHour[0] + ":" + pnMinute[0] + ":" + pfSecond[0];
        Date date = (Date)TypeTimestamp.INSTANCE.strToType(dateStr);
        return date;
    }
}

