/**
　 * <p>Title: GetEsriFieldType.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月9日
　 * @version 1.0
*/
package com.northpool.resources.datasource.fgdb;

import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeographicCoordinateSystem;
import org.fgdbapi.thindriver.xml.SpatialReference;

import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.type.FGDBTypeUtils;
import com.northpool.spatial.Constants.GEO_TYPE;

/**
 * @author matt
 *
 */
public class EsriTypeUtils {
    public static Field getEsriField(ColumnBean columnBean){
       return FGDBTypeUtils.getEsriField(columnBean);
    }
    
    
    public static EsriGeometryType geomType2EsriGeometryType(GEO_TYPE geoType){
        switch(geoType){
            case UNKNOWN:
                throw new RuntimeException("fgdb不支持UNKNOWN数据类型");
            case POINT:
                return EsriGeometryType.ESRI_GEOMETRY_POINT;
            case LINESTRING:
                return EsriGeometryType.ESRI_GEOMETRY_POLYLINE;
            case POLYGON:
                return EsriGeometryType.ESRI_GEOMETRY_POLYGON;
            case MULTIPOINT:
                return EsriGeometryType.ESRI_GEOMETRY_POINT;
            case MULTILINESTRING:
                return EsriGeometryType.ESRI_GEOMETRY_POLYLINE;
            case MULTIPOLYGON:
                return EsriGeometryType.ESRI_GEOMETRY_POLYGON;
            default:
                throw new RuntimeException("fgdb不支持" + geoType.name() + "数据类型");
        }
    }
    
    public static SpatialReference getSpatialReferenceBySRID(int srid){
        switch(srid){
            case 4490:
                return constructCGCS2000SpatialReference();
            case 4326: 
                return constructW84SpatialReference();
            case 4610: 
                return constructXIAN80SpatialReference();
            default:
                throw new RuntimeException("不支持SRID:" + srid);
        }
    }
    
    public static GeographicCoordinateSystem constructW84SpatialReference() {

        GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
        gcs.setWKID(4326);
        gcs.setWKT(
            "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]]");
        gcs.setHighPrecision(true);
        gcs.setXYScale(10000000000.0);
        gcs.setXOrigin(-200.0);
        gcs.setYOrigin(-100.0);
        gcs.setZOrigin(-1000.0);
        gcs.setMOrigin(0.0);
        gcs.setZScale(100.0);
        gcs.setMScale(100.0);
        gcs.setXYTolerance(0.0000000001);
        gcs.setLeftLongitude(-180.0);
        return gcs;
      }
      
      
      public static GeographicCoordinateSystem constructCGCS2000SpatialReference() {

          GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
          gcs.setWKID(4490);
          gcs.setWKT("GEOGCS[\"China Geodetic Coordinate System 2000\",DATUM[\"China_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4490\"]]");
          
          gcs.setHighPrecision(true);
          gcs.setXYScale(10000000000.0);
          gcs.setXOrigin(-180.0);
          gcs.setYOrigin(-90.0);
          gcs.setZOrigin(-100.0);
          gcs.setMOrigin(0.0);
          gcs.setZScale(100.0);
          gcs.setMScale(100.0);
          gcs.setXYTolerance(0.0000000001);
          gcs.setLeftLongitude(-180.0);
          return gcs;
        }
      
      public static GeographicCoordinateSystem constructXIAN80SpatialReference() {

          GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
          gcs.setWKID(4610);
          gcs.setWKT("GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]]");
          gcs.setHighPrecision(true);
          gcs.setXYScale(10000000000.0);
          gcs.setXOrigin(-180.0);
          gcs.setYOrigin(-90.0);
          gcs.setZOrigin(-100.0);
          gcs.setMOrigin(0.0);
          gcs.setZScale(100.0);
          gcs.setMScale(100.0);
          gcs.setXYTolerance(0.0000000001);
          gcs.setLeftLongitude(-180.0);
          return gcs;
        }
      
      
}
