/**
　 * <p>Title: FGDBUpdate.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月1日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.sql.IDML;
import com.northpool.type.Type;
import com.northpool.resources.sql.IBatchDataScroll;


/**
 * @author matt
 *
 */
public class FGDBDML implements IDML {

    protected FGDBDialect dialect;
    protected IFGDBTransformer<Void> transformer;
    protected Map<String,Type> returnTypeMap = new HashMap<String,Type>();
    protected Type[] inputTypes;
    protected FGDBDataSource dataSource;
    
    protected boolean ignoreWarnings = false;
    
    protected static final Logger logger = LoggerFactory.getLogger(FGDBDML.class);
    
    protected int batchsize;
    
    protected String tableName;
    
    protected String[] fields;
    
    public static enum DML_TYPE{
        insert,update,delete,batchInsert
    }
    
    protected DML_TYPE type;
    
    /**
     * @param dataSource
     * @param dialect
     * @param fgdbTable
     */
    FGDBDML(IDataSource dataSource, FGDBDialect dialect, String tableName,String[] fields,DML_TYPE type) {
        // TODO Auto-generated constructor stub
        this.dataSource = (FGDBDataSource)dataSource;
        this.dialect = dialect;
        this.tableName = tableName;
        this.fields = fields;
        this.type = type;
    }

    @Override
    public IDML setBatchSize(int batchsize) {
        this.batchsize = batchsize;
        return this;
    }

    @Override
    public void setInputTypes(Type[] inputTypes) {
        if(inputTypes != null){
            this.inputTypes = inputTypes;
        }
    }

    
   
    
    public void insert(Object[] args) throws DataAccessException {
        // TODO Auto-generated method stub
        Cmd insert = new Cmd(Cmd.CMD_TYPE.insert,this.tableName,this.fields,this.inputTypes,args) ;
        dataSource.connection().getESRIShell().addCmd(insert);
        try {
            int id = (int)insert.getPromise().get();
        } catch (InterruptedException | ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new DataAccessException("fgdb插入失败,错误:" + e.getMessage());
        }
    }
    
    

   
    
    public void batchInsert(IBatchDataScroll scroll) throws DataAccessException {
        // TODO Auto-generated method stub
        int index = 0;
        List<Object[]> ii = new ArrayList<>(this.batchsize);
        while(scroll.hasNext()){
            Object[] args = scroll.next();
            ii.add(args);
            if ((index + 1) % this.batchsize == 0) {
                this.insertList(ii);
            }
            index ++;
        }
        if (scroll.size() % batchsize != 0) {
            this.insertList(ii);
        }
    }
    
    private void insertList(List<Object[]> ii){
        Cmd insertList = new Cmd(Cmd.CMD_TYPE.insertbatch,this.tableName,this.fields,this.inputTypes,ii) ;
        dataSource.connection().getESRIShell().addCmd(insertList);
        try {
            insertList.getPromise().get();
        } catch (InterruptedException | ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new DataAccessException("fgdb批量插入失败,错误:" + e.getMessage());
        }
        ii.clear();
    }

 
    /* (non-Javadoc)
     * @see com.northpool.resources.sql.IDML#update(java.lang.Object[])
     */
    @Override
    public void update(Object[] args) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.sql.IDML#batchUpdate(com.northpool.resources.sql.IUpdateDataScroll)
     */
    @Override
    public void batchUpdate(IBatchDataScroll scroll) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

}
