/**
　 * <p>Title: FGDBDialect.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.dialect.fgdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import org.fgdbapi.thindriver.swig.Row;
import org.fgdbapi.thindriver.xml.Field;
import org.gdal.ogr.Feature;
import org.locationtech.jts.geom.Geometry;

import com.northpool.exception.NotSupport;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean.VALUE_TYPE;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.ADialect;
import com.northpool.resources.dialect.AbstractDialect;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.sql.SQLFunction;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.type.TypeFGDBGeometry;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;
import com.northpool.type.Types;

/**
 * @author matt
 *
 */
@ADialect(name = "fgdb",type = DATA_SOURCE_TYPE.fgdb)
public class FGDBDialect extends AbstractSQLDialect implements ISQLDialect {

    public static final IDialect INSTANCE = new FGDBDialect();
    
    public static final String KEY_WORD_SERIAL = "esriFieldTypeOID";
    
    public static final String KEY__WORD_GEOMETRY = "esriFieldTypeGeometry";

   
    @Override
    public String getSelfDesc() {
        // TODO Auto-generated method stub
        return "fgdb方言";
    }

   
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.fgdb;
    }

    
    @Override
    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
            return true;
        }
        return false;
    }

    
    @Override
    protected void registerTypes() {
        // TODO Auto-generated method stub
        this.registerType(Types.INTEGER, "serial","int", "int2", "int4", "integer");
        this.registerClassType(Types.INTEGER, Integer.class,Short.class);
        this.registerType(TypeFGDBGeometry.INSTANCE, "geometry");
        this.registerClassType(TypeFGDBGeometry.INSTANCE, Geometry.class,GeoBuffer.class,Geom.class);
        this.registerType(Types.STRING, "String");
        this.registerClassType(Types.STRING, String.class);
        this.registerType(Types.DOUBLE, "real","float4","float8","double");
        this.registerClassType(Types.DOUBLE, Double.class,Float.class);
        this.registerType(Types.BIGDECIMAL, "numeric","number");
        this.registerClassType(Types.BIGDECIMAL, BigDecimal.class,BigInteger.class);
        this.registerType(Types.TIME_STAMP, "timestamp","dateTime");
        this.registerClassType(Types.TIME_STAMP, Date.class);
        this.registerType(Types.BOOLEAN, "boolean", "bool");
        this.registerClassType(Types.BOOLEAN, Boolean.class);   
        this.registerType(Types.LONG, "long","int8");
        this.registerClassType(Types.LONG, Long.class); 
        this.registerType(TypeBytes.INSTANCE, "Binary","byte[]");
        this.registerClassType(TypeBytes.INSTANCE, byte[].class); 
    }

   
    @Override
    protected void registerFunctions() {
        Type[] typeIn = new Type[]{ TypeFGDBGeometry.INSTANCE, TypeFGDBGeometry.INSTANCE};
        this.registerFunction("intersects", new SQLSpatialRelateFunction("st_intersects", Types.BOOLEAN,typeIn));
        this.registerFunction("mbr_intersects", new SpatialFilterExpression(Types.BOOLEAN,typeIn));
        
        
    }


   
    @SuppressWarnings("unchecked")
    @Override
    public IResourcesDataInput<Row,String> getResourcesDataDataInput() {
        return FGDBResourcesDataInput.INSATNCE;
    }


   
    @SuppressWarnings("unchecked")
    @Override
    public  IResourcesDataOutput<Feature,Integer> getResourcesDataOutput() {
        return FGDBResourcesDataOutput.INSTANCE;
    }


 
    @SuppressWarnings("unchecked")
    @Override
    public  ICreateTableFieldRefDialect<FGDBTableBuilder,Field> getCreateTableFieldRefDialect() {
        return FGDBFieldRefDialect.INSTANCE;
    }


    /**
     * FDGB不支持该方法
     */
    @Override
    public String getLimitString(String sql, boolean hasOffset, List<Object> parameterList, List<Type> inputTypes,
        int firstResult, int maxResults) {
        throw new NotSupport();
    }


    
 

    /**
     * FGDB不支持
     */
    @Override
    public String getJDBCDriver() {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


   
    @Override
    public String createConnectUrl(String url) {
        // TODO Auto-generated method stub
        return url;
    }


    /**
     * FGDB不需要在SQL中表与字段加冒号
     */
    @Override
    public Boolean markForTableNameAndColumnName() {
        // TODO Auto-generated method stub
        return true;
    }


   
    @Override
    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


    
    @Override
    public String createInsertSQL(String schema, String tableName, String[] fields) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


    
    @Override
    public String createDeleteSQL(String schema, String tableName, String where) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


   
    @Override
    public String createUpdateSQL(String schema, String tableName, String[] fields, String where) {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


    
    @Override
    public String getDefaultSchema() {
        // TODO Auto-generated method stub
        throw new NotSupport();
    }


   
    @Override
    public Boolean isFieldSerial(String columnTypeName) {
        if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
            return true;
        }
        return false;
    }


    @Override
    public VALUE_TYPE getColumnDefaultValueType(String columnTypeName, String defaultValue) {
        throw new NotSupport();
    }


    
    @Override
    public String[] getCreateTableSQLS(TableSchemaBean tableSchemaBean) {
        throw new NotSupport();
    }


    
    @Override
    public String createSequenceName(String schema, String tableName, String fieldName) {
        throw new NotSupport();
    }


    
    @Override
    public String hasSequenceSql(String sequenceName) {
        throw new NotSupport();
    }


  
    @Override
    public String getCreateSequenceSQL(String sequenceName) {
        throw new NotSupport();
    }


    
    @Override
    public String processTableNameAndSchema(String tableName) {
        // TODO Auto-generated method stub
        return tableName;
    }


  
   


    


    


    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.sql.AbstractSQLDialect#defaultValueIsSequence(java.lang.String, java.lang.String)
     */
    @Override
    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        // TODO Auto-generated method stub
        return false;
    }


    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.sql.AbstractSQLDialect#defaultValueIsFuntion(java.lang.String, java.lang.String)
     */
    @Override
    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        // TODO Auto-generated method stub
        return false;
    }


    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.sql.AbstractSQLDialect#defaultValueIsNowDate(java.lang.String, java.lang.String)
     */
    @Override
    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        // TODO Auto-generated method stub
        return false;
    }


  


   

  

}
