/**
　 * <p>Title: IndexXMLBean.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月25日
　 * @version 1.0
*/
package com.northpool.resources.dialect.fgdb;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;



/**
 * @author matt
 *
 */
public class IndexXMLBean {
    String name;
    Boolean isUnique;
    Boolean isAscending;
    List<FieldXmlBean> fields;
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Boolean getIsUnique() {
        return isUnique;
    }
    public void setIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
    }
    public Boolean getIsAscending() {
        return isAscending;
    }
    public void setIsAscending(Boolean isAscending) {
        this.isAscending = isAscending;
    }
    public List<FieldXmlBean> getFields() {
        return fields;
    }
    public void setFields(List<FieldXmlBean> fields) {
        this.fields = fields;
    }
    
    
    public static IndexXMLBean fromXML(byte[] xml) throws DocumentException{
        IndexXMLBean bean = new IndexXMLBean();
        SAXReader reader = new SAXReader();
        Document document = reader.read(new ByteArrayInputStream(xml));
        Element e = document.getRootElement();
        bean.setName(e.elementText("Name"));
        bean.setIsAscending((Boolean.valueOf(e.elementText("IsAscending"))));
        bean.setIsUnique((Boolean.valueOf(e.elementText("IsUnique"))));
        List elements =  e.element("Fields").element("FieldArray").elements();
      
        List<FieldXmlBean> list = new ArrayList<>();
        bean.setFields(list);
        for(int i = 0 ; i < elements.size() ; i ++){
            Element element = (Element)elements.get(i);
            FieldXmlBean fieldXmlBean = new FieldXmlBean();
            fieldXmlBean.setName(element.elementText("Name"));
            fieldXmlBean.setType(element.elementText("Type"));
            fieldXmlBean.setIsNullable(Boolean.valueOf(element.elementText("IsNullable")));
            fieldXmlBean.setLength(Integer.valueOf(element.elementText("Length")));
            fieldXmlBean.setRequired(Boolean.valueOf(element.elementText("Required")));
            list.add(fieldXmlBean);
            
        }
        
        return bean;
        
        
    }
    
    
    
    /*public static void main(String[] aaaa) throws DocumentException{
        byte[] a = FileUtil.File2byte("C:\\tmp\\aaa.xml");
        IndexXMLBean.fromXML(a);
        
    }*/
    
}
