/**
　 * <p>Title: FGDBTypeUtils.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月10日
　 * @version 1.0
*/
package com.northpool.resources.type;

import java.math.BigDecimal;
import java.util.Date;

import org.fgdbapi.thindriver.swig.Row;
import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeometryDef;
import org.fgdbapi.thindriver.xml.SpatialReference;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.type.Type;
import com.northpool.type.Types;

/**
 * @author matt
 *
 */
public class FGDBTypeUtils {
    
    static byte[] ccc = null;
    
    
    public static Field getEsriField(ColumnBean columnBean){
        String typeName = columnBean.getTypeName();
       
        Type type =  Types.getTypeByName(typeName);
        if(type == null){
            throw new RuntimeException("不支持字段类型 " + typeName);
        }
        Field field = new Field();
        field.setName(columnBean.getColumnName());
        field.setModelName(columnBean.getRemarks() == null ? "" : columnBean.getRemarks());
        if(columnBean.getNullable()){
            field.setIsNullable(true);
        }else{
            field.setIsNullable(false);
        }
        field.setEditable(true);
        
        switch(type.getEnum()){
            case Integer:
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
                field.setLength(4);
                break;
            case Boolean: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_SMALL_INTEGER);
                break;
            case Double: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
                field.setLength(8);
                break; 
            case Geometry: 
                EsriGeometryType geomType = EsriTypeUtils.geomType2EsriGeometryType(columnBean.getGeoType());;
                SpatialReference gcs = EsriTypeUtils.getSpatialReferenceBySRID(columnBean.getSrid());
                GeometryDef geom = new GeometryDef();
                geom.setGeometryType(geomType);
                geom.setSpatialReference(gcs);
                geom.setGridSize0((double) 0);
                geom.setHasM(false);
                geom.setHasZ(false);
                field.setGeometryDef(geom);
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_GEOMETRY);
                break; 
            case BigDecimal: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
                field.setLength(8);
                break; 
                
            case Long: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
                field.setLength(8);
                break; 
            case Timestamp: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DATE);
                break; 
            case String: 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_STRING);
                if(columnBean.getColumnSize() != null){
                    field.setLength(columnBean.getColumnSize());
                }
                break; 
           /* case Blob : 
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_BLOB);
                break;    */
            default : 
                throw new RuntimeException("fgdb不支持类型" + type.name());
                
        }
        return field;
    }
    
    
    public static void setFGDBValueByType(Row row,String fieldName,Object object,Type type) throws Exception{
       // row.set
    /*    object = type.toType(object); 
       
        if(object == null){
            row.setNull(fieldName);
            return;
        }
        switch(type.getRefTypeName().toLowerCase()){
            case "integer":
                row.setInteger(fieldName, (int)object);
                break;
            case "boolean":
                Boolean bl = (Boolean)object;
                if(bl == true){
                    row.setShort(fieldName,(short)1 );
                }else{
                    row.setShort(fieldName,(short)0 );
                }
                break;
            case "double": 
                row.setDouble(fieldName, (double)object);
                break; 
            case "geometry": 
                
                byte[] c;
                
                row.setGeometry(c);
                break; 
            case "bigdecimal":
                BigDecimal bigdecimal = (BigDecimal)object;
                row.setDouble(fieldName, bigdecimal.doubleValue());
                break; 
            case "long": 
                //row.setInteger(fieldName, value);
                throw new RuntimeException("有问题,后续改");
            case "timestamp": 
                Date d = (Date)object;
                
                row.setDate(fieldName,(long)(d.getTime() / 1000));
                break; 
            case "string": 
                row.setString(fieldName, (String)object);
                break; 
            case "blob" : 
                throw new RuntimeException("有问题,后续改");
            default : 
                throw new RuntimeException("fgdb不支持类型" + type.name());
        }*/
    }
}
