/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.FGDBConnection;
import com.northpool.resources.datasource.fgdb.FGDB_ESRIShell;
import com.northpool.resources.datasource.fgdb.FGDB_GDALShell;
import com.northpool.resources.datasource.fgdb.GDBPool;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;

@ADataSource(name="fgdb", types="fgdb,gdb")
public class FGDBDataSource
extends AbstractDataSource
implements IDataSource {
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FGDBDataSource(String filePath) {
        this.filePath = filePath;
        if (this.id == null) {
            this.id = this.processFileURL(filePath);
        }
        this.dataSourceType = Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public FGDBDataSource(String id, String filePath) {
        this.filePath = filePath;
        if (this.id == null) {
            this.id = this.processFileURL(filePath);
        }
    }

    private String processFileURL(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        ArrayList<String> array = new ArrayList<String>();
        Iterator<Path> iterator = path.iterator();
        while (iterator.hasNext()) {
            array.add(iterator.next().toString());
        }
        return String.join((CharSequence)"|", array);
    }

    FGDBDataSource() {
    }

    public String toJson() {
        return JSON.toJSON((Object)((Object)this)).toString();
    }

    public String mark() {
        return this.dataSourceType.name() + '_' + this.processFileURL(this.filePath);
    }

    public void testConnection() throws Exception {
        FGDB_GDALShell shell = new FGDB_GDALShell(this.filePath);
        shell.load();
    }

    public FGDBConnection connection() {
        return new FGDBConnection(this.filePath);
    }

    public void resetConnection() {
    }

    public void destory() {
        GDBPool.getPool().close(this.filePath);
    }

    public void create() {
        FGDB_ESRIShell.create(this.filePath);
    }

    @Deprecated
    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    @Deprecated
    public Boolean executeSqlCommand(String sql) {
        return null;
    }
}

