/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.fgdb;

import com.northpool.resources.datatable.fgdb.AbstractFGDBTransformer;
import com.northpool.resources.datatable.fgdb.IFGDBTransformer;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeFGDBGeometry;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gdal.ogr.Feature;

public class ArrayFGDBTransformer
extends AbstractFGDBTransformer<Object[]>
implements IFGDBTransformer<Object[]> {
    @Override
    protected ResultSetMapping<Object[], AbstractFGDBTransformer.Cursor> getMapping() {
        return new ResultSetMapping<Object[], AbstractFGDBTransformer.Cursor>(){

            public Object[] mapping(AbstractFGDBTransformer.Cursor cursor, LinkedHashMap<String, Type> typeLink, IDialect dialect) {
                Feature feature = cursor.getValue();
                IResourcesDataOutput output = dialect.getResourcesDataOutput();
                Object[] values = new Object[typeLink.entrySet().size()];
                Iterator<Map.Entry<String, Type>> iterator = typeLink.entrySet().iterator();
                int indexInQueryFieldArray = 0;
                int indexInDataOutput = 0;
                while (iterator.hasNext()) {
                    Type type = iterator.next().getValue();
                    Object object = null;
                    if (type.getEnum() != TypeFGDBGeometry.INSTANCE.getEnum()) {
                        object = output.output((Object)feature, type, (Object)indexInDataOutput);
                        ++indexInDataOutput;
                    } else {
                        object = output.output((Object)feature, type, null);
                    }
                    values[indexInQueryFieldArray] = object;
                    ++indexInQueryFieldArray;
                }
                feature.delete();
                return values;
            }
        };
    }
}

