/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.fgdb;

import com.northpool.resources.datatable.fgdb.AbstractFGDBTransformer;
import com.northpool.resources.datatable.fgdb.IFGDBTransformer;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeFGDBGeometry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gdal.ogr.Feature;

public class MapFGDBTransformer
extends AbstractFGDBTransformer
implements IFGDBTransformer<Map<String, Object>> {
    protected ResultSetMapping getMapping() {
        return new ResultSetMapping<Map<String, Object>, AbstractFGDBTransformer.Cursor>(){

            public Map<String, Object> mapping(AbstractFGDBTransformer.Cursor cursor, LinkedHashMap<String, Type> typeLink, IDialect dialect) {
                Feature feature = cursor.getValue();
                IResourcesDataOutput output = dialect.getResourcesDataOutput();
                HashMap<String, Object> map = new HashMap<String, Object>(typeLink.size());
                Iterator<Map.Entry<String, Type>> iterator = typeLink.entrySet().iterator();
                int indexInQueryFieldArray = 0;
                int indexInDataOutput = 0;
                while (iterator.hasNext()) {
                    Map.Entry<String, Type> entry = iterator.next();
                    Type type = entry.getValue();
                    Object object = null;
                    if (type.getEnum() != TypeFGDBGeometry.INSTANCE.getEnum()) {
                        object = output.output((Object)feature, type, (Object)indexInDataOutput);
                        ++indexInDataOutput;
                    } else {
                        object = output.output((Object)feature, type, null);
                    }
                    map.put(entry.getKey(), object);
                    ++indexInQueryFieldArray;
                }
                feature.delete();
                return map;
            }
        };
    }
}

