/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.fgdb.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datasource.fgdb.FGDB_GDALShell;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.fgdb.FGBDTable;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.dialect.fgdb.FieldXmlBean;
import com.northpool.resources.dialect.fgdb.IndexXMLBean;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.spatial.geofeature.GeoBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ATableOperator(name="fgdb", type=Constants.DATA_SOURCE_TYPE.fgdb)
public class FGDBOperator
extends AbstractTableOperator
implements ITableOperator {
    FGDBDataSource fGDBDataSource;
    FGDB_GDALShell gdalShell;
    Logger logger = LoggerFactory.getLogger(FGDBOperator.class);

    public String mark() {
        return this.tableName + "@" + this.dataSource.mark();
    }

    protected CompletableFuture<Object> getEmptyPromise() {
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> null);
        return promise;
    }

    public CompletableFuture<Object> createPK(String colname) {
        this.logger.info("fgdb \u4e0d\u652f\u6301\u521b\u5efa\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    public CompletableFuture<Object> _createIndex(Boolean unique, String ... colnames) {
        Index index = new Index();
        index.setName(this.createIndexName(colnames));
        index.setUnique(unique);
        for (String colname : colnames) {
            index.addColname(colname);
        }
        index.setSpatial(Boolean.valueOf(true));
        index.setUnique(Boolean.valueOf(true));
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.createindex, this.tableName, index);
        this.fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        CompletableFuture<Object> promise = cmd.getPromise();
        promise.thenAccept(arg_0 -> this.lambda$_createIndex$1((IIndex)index, arg_0));
        return promise;
    }

    public CompletableFuture<Object> dropIndex(String indexName) {
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.droptable, this.tableName, indexName);
        this.fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        return cmd.getPromise();
    }

    public CompletableFuture<Object> dropPK() {
        this.logger.info("fgdb \u4e0d\u652f\u6301\u5220\u9664\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    protected Object[] getSpatialInfo(String colunmName) throws Exception {
        return null;
    }

    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws Exception {
        return null;
    }

    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;
        this.dataSource = (FGDBDataSource)dataSource;
        this.fGDBDataSource = (FGDBDataSource)dataSource;
        this.gdalShell = this.fGDBDataSource.connection().getGDALShell();
        this.dialect = FGDBDialect.INSTANCE;
        this.buildTableInfo(this.tableName);
    }

    protected void buildTableInfo(String tableName) throws TableNotFoundException {
        this.getTableInfo(tableName);
        this.buildColumns(tableName);
        this.buildIndexInfo(tableName);
    }

    protected void getTableInfo(String tableName) throws TableNotFoundException {
        this.isView = false;
        this.tableRemarks = this.gdalShell.geTableRemarks(tableName);
    }

    protected void buildColumns(String tableName) throws TableNotFoundException {
        this.columnMap = this.gdalShell.getColumnMap(tableName);
    }

    protected List<Index> getIndexInfo(String tableName) {
        FGDBDataSource gdbDataSource = (FGDBDataSource)this.dataSource;
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.getIndex, tableName);
        gdbDataSource.connection().getESRIShell().addCmd(cmd);
        try {
            List indexBeanList = (List)cmd.getPromise().get();
            ArrayList<Index> indexList = new ArrayList<Index>(indexBeanList.size());
            for (IndexXMLBean indexBean : indexBeanList) {
                Index index = new Index();
                index.setName(indexBean.getName());
                index.setUnique(indexBean.getIsUnique());
                if (indexBean.getFields().size() == 1) {
                    if ("esriFieldTypeOID".equalsIgnoreCase(indexBean.getFields().get(0).getType())) {
                        index.setIsPK(Boolean.valueOf(true));
                    }
                    if ("esriFieldTypeGeometry".equalsIgnoreCase(indexBean.getFields().get(0).getType())) {
                        index.setSpatial(Boolean.valueOf(true));
                    }
                }
                for (FieldXmlBean field : indexBean.getFields()) {
                    index.addColname(field.getName());
                }
                indexList.add(index);
            }
            return indexList;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void buildIndexInfo(String tableName) throws TableNotFoundException {
        List<Index> indexList = this.getIndexInfo(tableName);
        for (Index index : indexList) {
            this.indexMap.put(index.getName(), index);
        }
    }

    protected AbstractTable _getTable() {
        return new FGBDTable();
    }

    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        Index index = new Index();
        index.setName(this.createSpatialIndexName(colname));
        index.addColname(colname);
        index.setSpatial(Boolean.valueOf(true));
        index.setUnique(Boolean.valueOf(true));
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.createindex, this.tableName, index);
        this.fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        CompletableFuture<Object> promise = cmd.getPromise();
        promise.thenAccept(arg_0 -> this.lambda$createSpatialIndex$2((IIndex)index, arg_0));
        return promise;
    }

    private /* synthetic */ void lambda$createSpatialIndex$2(IIndex index, Object object) {
        this.addToIndexMap(index.getName(), index);
    }

    private /* synthetic */ void lambda$_createIndex$1(IIndex index, Object object) {
        this.addToIndexMap(index.getName(), index);
    }
}

