/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.fgdb;

import com.northpool.resources.Constants;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeDouble;
import com.northpool.type.TypeFGDBGeometry;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeString;
import com.northpool.type.TypeTimestamp;
import java.math.BigDecimal;
import java.util.Date;
import org.fgdbapi.thindriver.swig.Row;

public class FGDBResourcesDataInput
implements IResourcesDataInput<Row, String> {
    public static final FGDBResourcesDataInput INSATNCE = new FGDBResourcesDataInput();

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.fgdb;
    }

    public void columnBoolean(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (TypeBoolean.INSTANCE.isType(value)) {
            Boolean bl = (Boolean)value;
            if (bl.booleanValue()) {
                input.setShort(indexOrLabelName, (short)1);
            } else {
                input.setShort(indexOrLabelName, (short)0);
            }
        } else {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeBoolean.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
    }

    public void columnBigDecimal(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (!TypeBigDecimal.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeBigDecimal.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        BigDecimal bigdecimal = (BigDecimal)value;
        input.setDouble(indexOrLabelName, bigdecimal.doubleValue());
    }

    public void columnBytes(Row input, Object value, String indexOrLabelName) throws Exception {
        throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301");
    }

    public void columnDouble(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (!TypeDouble.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeDouble.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setDouble(indexOrLabelName, ((Double)value).doubleValue());
    }

    public void columnGeometry(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            throw new RuntimeException("\u7a7a\u95f4\u5b57\u6bb5\u4e0d\u5141\u8bb8\u63d2\u5165\u7a7a");
        }
        if (!TypeFGDBGeometry.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeDouble.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Geom geom = (Geom)value;
        byte[] bytes = (byte[])geom.getOriginGeom();
        input.setGeometry(bytes);
    }

    public void columnInteger(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (!TypeInteger.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeInteger.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setInteger(indexOrLabelName, ((Integer)value).intValue());
    }

    public void columnLong(Row input, Object value, String indexOrLabelName) throws Exception {
        throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301");
    }

    public void columnString(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (!TypeString.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeString.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        input.setString(indexOrLabelName, (String)value);
        input.setString(indexOrLabelName, (String)value);
    }

    public void columnTimestamp(Row input, Object value, String indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName);
            return;
        }
        if (!TypeTimestamp.INSTANCE.isType(value)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeTimestamp.INSTANCE, value, "\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Date d = (Date)value;
        input.setDate(indexOrLabelName, d.getTime() / 1000L);
    }
}

