/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.fgdb;

import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.fgdb.FGDBFieldRefDialect;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.fgdbapi.thindriver.tools.Tools;
import org.fgdbapi.thindriver.xml.ArrayOfControllerMembership;
import org.fgdbapi.thindriver.xml.ArrayOfField;
import org.fgdbapi.thindriver.xml.ArrayOfIndex;
import org.fgdbapi.thindriver.xml.ArrayOfPropertySetProperty;
import org.fgdbapi.thindriver.xml.DEFeatureClass;
import org.fgdbapi.thindriver.xml.DETable;
import org.fgdbapi.thindriver.xml.DataElement;
import org.fgdbapi.thindriver.xml.EsriDatasetType;
import org.fgdbapi.thindriver.xml.EsriFeatureType;
import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.Fields;
import org.fgdbapi.thindriver.xml.Indexes;
import org.fgdbapi.thindriver.xml.Names;
import org.fgdbapi.thindriver.xml.ObjectFactory;
import org.fgdbapi.thindriver.xml.PropertySet;

public class FGDBTableBuilder {
    private DETable dataElement;
    private String name;
    private Field spatialField;
    public static final String ID_FIELD_NAME = "GDB_OBJECTID";
    TableSchemaBean tableSchemaBean;

    public FGDBTableBuilder(TableSchemaBean tableSchemaBean) {
        this.tableSchemaBean = tableSchemaBean;
    }

    private void createTableAndPkIndex(TableSchemaBean tableSchemaBean) {
        String name = tableSchemaBean.getTableName();
        String[] tableNameArr = name.split("\\.");
        if (tableNameArr.length > 1) {
            name = tableNameArr[tableNameArr.length - 1];
        }
        Field o = new Field();
        o.setName(ID_FIELD_NAME);
        o.setType(EsriFieldType.ESRI_FIELD_TYPE_OID);
        o.setLength(4);
        o.setRequired(Boolean.valueOf(true));
        o.setIsNullable(false);
        o.setEditable(Boolean.valueOf(false));
        o.setAliasName(o.getName());
        o.setModelName("\u81ea\u589e\u4e3b\u952e");
        Fields flds = new Fields();
        flds.setFieldArray(new ArrayOfField());
        flds.getFieldArray().getField().add(o);
        ArrayOfIndex arrayOfIndex = new ArrayOfIndex();
        this.dataElement = new DETable();
        Indexes indices = new Indexes();
        indices.setIndexArray(arrayOfIndex);
        this.dataElement.setIndexes(indices);
        this.dataElement.setCatalogPath("\\" + name);
        this.dataElement.setName(name);
        this.dataElement.setChildrenExpanded(Boolean.valueOf(false));
        this.dataElement.setOIDFieldName(ID_FIELD_NAME);
        this.dataElement.setHasOID(true);
        this.dataElement.setDatasetType(EsriDatasetType.ESRI_DT_TABLE);
        this.dataElement.setVersioned(Boolean.valueOf(false));
        this.dataElement.setControllerMemberships(new ArrayOfControllerMembership());
        this.dataElement.setCLSID("{" + UUID.randomUUID().toString() + "}");
        this.dataElement.setModelName(name);
        this.dataElement.setAliasName(name);
        this.dataElement.setFields(flds);
    }

    void newTable(TableSchemaBean tableSchemaBean) throws Exception {
        this.createTableAndPkIndex(tableSchemaBean);
        DEFeatureClass fc = new DEFeatureClass();
        Tools.copy((Object)this.dataElement, (Object)fc);
        this.dataElement = fc;
        Collection collection = tableSchemaBean.getColumnMap().values();
        for (ColumnBean columnBean : collection) {
            if (columnBean.getIsPK().booleanValue()) {
                this.addIdColumn(columnBean);
                continue;
            }
            Field field = (Field)FGDBFieldRefDialect.INSTANCE.column(this, columnBean);
            if (!columnBean.getIsSpatial().booleanValue()) continue;
            this.spatialField = field;
        }
        fc.setFeatureType(EsriFeatureType.ESRI_FT_SIMPLE);
        fc.setShapeType(this.spatialField.getGeometryDef().getGeometryType());
        fc.setRelationshipClassNames(new Names());
        fc.setShapeFieldName(this.spatialField.getName());
        fc.setHasM(Boolean.valueOf(false));
        fc.setHasZ(Boolean.valueOf(false));
        fc.setDatasetType(EsriDatasetType.ESRI_DT_FEATURE_CLASS);
        fc.setCLSID("{52353152-891A-11D0-BEC6-00805F7C4268}");
        fc.setHasSpatialIndex(Boolean.valueOf(false));
        fc.setSpatialReference(this.spatialField.getGeometryDef().getSpatialReference());
    }

    void addIdColumn(ColumnBean columnBean) {
        String name = columnBean.getColumnName();
        if (ID_FIELD_NAME.equalsIgnoreCase(name)) {
            return;
        }
        Field field = EsriTypeUtils.getEsriField(columnBean);
        this.addField(field);
    }

    void addSpatialColumn(FGDBTableBuilder th, ColumnBean columnBean) {
        Field field = EsriTypeUtils.getEsriField(columnBean);
        th.addField(field);
    }

    DETable build() throws Exception {
        this.newTable(this.tableSchemaBean);
        PropertySet ps = new PropertySet();
        this.dataElement.setExtensionProperties(ps);
        ps.setPropertyArray(new ArrayOfPropertySetProperty());
        return this.dataElement;
    }

    public String buildCreateTableXML() throws Exception {
        return this.serializeElement(this.build());
    }

    public String getName() {
        return this.name;
    }

    protected String serializeElement(DETable de) throws Exception {
        JAXBContext isn = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        Marshaller m = isn.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        class NP
        extends NamespacePrefixMapper {
            NP() {
            }

            public String getPreferredPrefix(String arg0, String arg1, boolean arg2) {
                if (arg0.equals("http://www.esri.com/schemas/ArcGIS/10.1")) {
                    return "esri";
                }
                if (arg0.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    return "xsi";
                }
                return null;
            }
        }
        m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NP());
        StringWriter sw = new StringWriter();
        m.marshal((Object)new JAXBElement(new QName("http://www.esri.com/schemas/ArcGIS/10.1", "DataElement"), DataElement.class, (Object)de), (Writer)sw);
        String rawResult = sw.getBuffer().toString();
        rawResult = rawResult.replace("<ExtensionProperties", "<ExtensionProperties xsi:type=\"esri:PropertySet\"");
        rawResult = rawResult.replace("<PropertyArray", "<PropertyArray xsi:type=\"esri:ArrayOfPropertySetProperty\"");
        rawResult = rawResult.replace("<ControllerMemberships", "<ControllerMemberships xsi:type=\"esri:ArrayOfControllerMembership\"");
        rawResult = rawResult.replace("<Fields", "<Fields xsi:type=\"esri:Fields\"");
        rawResult = rawResult.replace("<FieldArray", "<FieldArray xsi:type=\"esri:ArrayOfField\"");
        rawResult = rawResult.replace("<Field ", "<Field xsi:type=\"esri:Field\" ");
        rawResult = rawResult.replace("<Field>", "<Field xsi:type=\"esri:Field\">");
        rawResult = rawResult.replace("<GeometryDef", "<GeometryDef xsi:type=\"esri:GeometryDef\"");
        rawResult = rawResult.replace("<Indexes", "<Indexes xsi:type=\"esri:Indexes\"");
        rawResult = rawResult.replace("<IndexArray", "<IndexArray xsi:type=\"esri:ArrayOfIndex\"");
        rawResult = rawResult.replace("<Index>", "<Index xsi:type=\"esri:Index\">");
        rawResult = rawResult.replace("<RelationshipClassNames", "<RelationshipClassNames xsi:type=\"esri:Names\"");
        return rawResult;
    }

    public FGDBTableBuilder addField(Field f) {
        this.dataElement.getFields().getFieldArray().getField().add(f);
        return this;
    }
}

