/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.type;

import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.type.Type;
import com.northpool.type.Types;
import org.fgdbapi.thindriver.swig.Row;
import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeometryDef;
import org.fgdbapi.thindriver.xml.SpatialReference;

public class FGDBTypeUtils {
    static byte[] ccc = null;

    public static Field getEsriField(ColumnBean columnBean) {
        String typeName = columnBean.getTypeName();
        Type type = Types.getTypeByName((String)typeName);
        if (type == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u5b57\u6bb5\u7c7b\u578b " + typeName);
        }
        Field field = new Field();
        field.setName(columnBean.getColumnName());
        field.setModelName(columnBean.getRemarks() == null ? "" : columnBean.getRemarks());
        if (columnBean.getNullable().booleanValue()) {
            field.setIsNullable(true);
        } else {
            field.setIsNullable(false);
        }
        field.setEditable(Boolean.valueOf(true));
        switch (type.getEnum()) {
            case Integer: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
                field.setLength(4);
                break;
            }
            case Boolean: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_SMALL_INTEGER);
                break;
            }
            case Double: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
                field.setLength(8);
                break;
            }
            case Geometry: {
                EsriGeometryType geomType = EsriTypeUtils.geomType2EsriGeometryType(columnBean.getGeoType());
                SpatialReference gcs = EsriTypeUtils.getSpatialReferenceBySRID(columnBean.getSrid());
                GeometryDef geom = new GeometryDef();
                geom.setGeometryType(geomType);
                geom.setSpatialReference(gcs);
                geom.setGridSize0(Double.valueOf(0.0));
                geom.setHasM(false);
                geom.setHasZ(false);
                field.setGeometryDef(geom);
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_GEOMETRY);
                break;
            }
            case BigDecimal: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
                field.setLength(8);
                break;
            }
            case Long: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
                field.setLength(8);
                break;
            }
            case Timestamp: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_DATE);
                break;
            }
            case String: {
                field.setType(EsriFieldType.ESRI_FIELD_TYPE_STRING);
                if (columnBean.getColumnSize() == null) break;
                field.setLength(columnBean.getColumnSize().intValue());
                break;
            }
            default: {
                throw new RuntimeException("fgdb\u4e0d\u652f\u6301\u7c7b\u578b" + type.name());
            }
        }
        return field;
    }

    public static void setFGDBValueByType(Row row, String fieldName, Object object, Type type) throws Exception {
    }
}

